/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.spotify.asyncdatastoreclient.AllocateIds;
import com.spotify.asyncdatastoreclient.Batch;
import com.spotify.asyncdatastoreclient.Delete;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Filter;
import com.spotify.asyncdatastoreclient.Group;
import com.spotify.asyncdatastoreclient.Insert;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.KeyQuery;
import com.spotify.asyncdatastoreclient.Order;
import com.spotify.asyncdatastoreclient.Query;
import com.spotify.asyncdatastoreclient.Update;
import com.spotify.asyncdatastoreclient.Value;
import java.util.List;

public class QueryBuilder {
    public static Insert insert(String kind) {
        return new Insert(Key.builder(kind).build());
    }

    public static Insert insert(String kind, long id) {
        return new Insert(Key.builder(kind, id).build());
    }

    public static Insert insert(String kind, String name) {
        return new Insert(Key.builder(kind, name).build());
    }

    public static Insert insert(Key key) {
        return new Insert(key);
    }

    public static Insert insert(Entity entity) {
        return new Insert(entity);
    }

    public static Update update(String kind) {
        return new Update(Key.builder().path(kind).build());
    }

    public static Update update(String kind, long id) {
        return new Update(Key.builder().path(kind, id).build());
    }

    public static Update update(String kind, String name) {
        return new Update(Key.builder().path(kind, name).build());
    }

    public static Update update(Key key) {
        return new Update(key);
    }

    public static Update update(Entity entity) {
        return new Update(entity);
    }

    public static Delete delete(String kind, long id) {
        return new Delete(Key.builder().path(kind, id).build());
    }

    public static Delete delete(String kind, String name) {
        return new Delete(Key.builder().path(kind, name).build());
    }

    public static Delete delete(Key key) {
        return new Delete(key);
    }

    public static AllocateIds allocate(List<Key> keys) {
        return new AllocateIds(keys);
    }

    public static AllocateIds allocate() {
        return new AllocateIds();
    }

    public static Batch batch() {
        return new Batch();
    }

    public static KeyQuery query(String kind, long id) {
        return new KeyQuery(Key.builder().path(kind, id).build());
    }

    public static KeyQuery query(String kind, String name) {
        return new KeyQuery(Key.builder().path(kind, name).build());
    }

    public static KeyQuery query(Key key) {
        return new KeyQuery(key);
    }

    public static Query query() {
        return new Query();
    }

    public static Filter eq(String name, Object value) {
        return new Filter(name, Filter.Operator.EQUAL, Value.builder().value(value).build());
    }

    public static Filter lt(String name, Object value) {
        return new Filter(name, Filter.Operator.LESS_THAN, Value.builder().value(value).build());
    }

    public static Filter lte(String name, Object value) {
        return new Filter(name, Filter.Operator.LESS_THAN_OR_EQUAL, Value.builder().value(value).build());
    }

    public static Filter gt(String name, Object value) {
        return new Filter(name, Filter.Operator.GREATER_THAN, Value.builder().value(value).build());
    }

    public static Filter gte(String name, Object value) {
        return new Filter(name, Filter.Operator.GREATER_THAN_OR_EQUAL, Value.builder().value(value).build());
    }

    public static Filter ancestor(String kind, long id) {
        return new Filter("__key__", Filter.Operator.HAS_ANCESTOR, Value.builder().value(Key.builder(kind, id).build()).build());
    }

    public static Filter ancestor(String kind, String name) {
        return new Filter("__key__", Filter.Operator.HAS_ANCESTOR, Value.builder().value(Key.builder(kind, name).build()).build());
    }

    public static Filter ancestor(Key key) {
        return new Filter("__key__", Filter.Operator.HAS_ANCESTOR, Value.builder().value(key).build());
    }

    public static Order asc(String name) {
        return new Order(name, Order.Direction.ASCENDING);
    }

    public static Order desc(String name) {
        return new Order(name, Order.Direction.DESCENDING);
    }

    public static Group group(String name) {
        return new Group(name);
    }
}

