/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.protobuf.ByteString;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Result;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class QueryResult
implements Result,
Iterable<Entity> {
    private final List<Entity> entities;
    private final ByteString cursor;

    private QueryResult(List<Entity> entities) {
        this.entities = entities;
        this.cursor = null;
    }

    private QueryResult(List<Entity> entities, ByteString cursor) {
        this.entities = entities;
        this.cursor = cursor;
    }

    static QueryResult build(DatastoreV1.LookupResponse response) {
        return new QueryResult((List<Entity>)ImmutableList.copyOf((Collection)response.getFoundList().stream().map(entity -> Entity.builder(entity.getEntity()).build()).collect(Collectors.toList())));
    }

    static QueryResult build(DatastoreV1.RunQueryResponse response) {
        DatastoreV1.QueryResultBatch batch = response.getBatch();
        return new QueryResult((List<Entity>)ImmutableList.copyOf((Collection)batch.getEntityResultList().stream().map(entity -> Entity.builder(entity.getEntity()).build()).collect(Collectors.toList())), batch.hasEndCursor() ? batch.getEndCursor() : null);
    }

    public static QueryResult build() {
        return new QueryResult((List<Entity>)ImmutableList.of());
    }

    public Entity getEntity() {
        return (Entity)Iterables.getFirst(this.entities, null);
    }

    public List<Entity> getAll() {
        return this.entities;
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.entities.iterator();
    }

    public ByteString getCursor() {
        return this.cursor;
    }
}

