/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Key;
import com.spotify.asyncdatastoreclient.KeyedStatement;
import com.spotify.asyncdatastoreclient.MutationStatement;
import java.util.List;

public class Update
extends KeyedStatement
implements MutationStatement {
    private boolean upsert;
    protected Entity.Builder entity;

    Update(Key key) {
        super(key);
        this.entity = Entity.builder(key);
    }

    Update(Entity entity) {
        super(entity.getKey());
        this.entity = Entity.builder(entity);
    }

    public Update value(String name, Object value) {
        this.entity.property(name, value);
        return this;
    }

    public Update value(String name, Object value, boolean indexed) {
        this.entity.property(name, value, indexed);
        return this;
    }

    public Update value(String name, List<Object> values) {
        this.entity.property(name, values);
        return this;
    }

    public Update value(String name, List<Object> values, boolean indexed) {
        this.entity.property(name, values, indexed);
        return this;
    }

    public Update upsert() {
        this.upsert = true;
        return this;
    }

    @Override
    public DatastoreV1.Mutation getPb(String namespace) {
        DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
        if (this.upsert) {
            mutation.addUpsert(this.entity.build().getPb(namespace));
        } else {
            mutation.addUpdate(this.entity.build().getPb(namespace));
        }
        return mutation.build();
    }
}

