/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Value {
    private final DatastoreV1.Value value;

    private Value(DatastoreV1.Value value) {
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Value value) {
        return new Builder(value);
    }

    public static Builder builder(Object value) {
        return new Builder().value(value);
    }

    public static Builder builder(List<Object> values) {
        return new Builder().value(values);
    }

    static Builder builder(DatastoreV1.Value value) {
        return new Builder(value);
    }

    public String getString() {
        if (!this.value.hasStringValue()) {
            throw new IllegalArgumentException("Value does not contain a string.");
        }
        return this.value.getStringValue();
    }

    public long getInteger() {
        if (!this.value.hasIntegerValue()) {
            throw new IllegalArgumentException("Value does not contain an integer.");
        }
        return this.value.getIntegerValue();
    }

    public boolean getBoolean() {
        if (!this.value.hasBooleanValue()) {
            throw new IllegalArgumentException("Value does not contain a boolean.");
        }
        return this.value.getBooleanValue();
    }

    public double getDouble() {
        if (!this.value.hasDoubleValue()) {
            throw new IllegalArgumentException("Value does not contain a double.");
        }
        return this.value.getDoubleValue();
    }

    public Date getDate() {
        if (this.value.hasMeaning() && this.value.getMeaning() == 18 && this.value.hasIntegerValue()) {
            return new Date(this.value.getIntegerValue() / 1000L);
        }
        if (this.value.hasTimestampMicrosecondsValue()) {
            return new Date(this.value.getTimestampMicrosecondsValue() / 1000L);
        }
        throw new IllegalArgumentException("Value does not contain a timestamp.");
    }

    public ByteString getBlob() {
        if (this.value.hasMeaning() && this.value.getMeaning() == 18 && this.value.hasStringValue()) {
            return this.value.getStringValueBytes();
        }
        if (this.value.hasBlobValue()) {
            return this.value.getBlobValue();
        }
        throw new IllegalArgumentException("Value does not contain a blob.");
    }

    public Entity getEntity() {
        if (!this.value.hasEntityValue()) {
            throw new IllegalArgumentException("Value does not contain an entity.");
        }
        return Entity.builder(this.value.getEntityValue()).build();
    }

    public Key getKey() {
        if (!this.value.hasKeyValue()) {
            throw new IllegalArgumentException("Value does not contain an key.");
        }
        return Key.builder(this.value.getKeyValue()).build();
    }

    public List<Value> getList() {
        if (this.value.getListValueCount() == 0) {
            throw new IllegalArgumentException("Value does not contain a list.");
        }
        return ImmutableList.copyOf((Collection)this.value.getListValueList().stream().map(value -> Value.builder(value).build()).collect(Collectors.toList()));
    }

    public <T> List<T> getList(Class<T> clazz) {
        return ImmutableList.copyOf((Collection)this.getList().stream().map(value -> value.convert(clazz)).collect(Collectors.toList()));
    }

    <T> T convert(Class<T> clazz) {
        if (clazz.equals(String.class)) {
            return (T)this.getString();
        }
        if (clazz.equals(Long.class)) {
            return (T)Long.valueOf(this.getInteger());
        }
        if (clazz.equals(Double.class)) {
            return (T)Double.valueOf(this.getDouble());
        }
        if (clazz.equals(Boolean.class)) {
            return (T)Boolean.valueOf(this.getBoolean());
        }
        if (clazz.equals(Date.class)) {
            return (T)this.getDate();
        }
        if (clazz.equals(ByteString.class)) {
            return (T)this.getBlob();
        }
        if (clazz.equals(Entity.class)) {
            return (T)this.getEntity();
        }
        if (clazz.equals(Key.class)) {
            return (T)this.getKey();
        }
        throw new IllegalArgumentException("Unrecognised value type.");
    }

    public boolean isIndexed() {
        return this.value.hasIndexed() && this.value.getIndexed();
    }

    DatastoreV1.Value getPb() {
        return this.value;
    }

    DatastoreV1.Value getPb(String namespace) {
        if (this.value.hasKeyValue()) {
            return DatastoreV1.Value.newBuilder((DatastoreV1.Value)this.value).setKeyValue(this.getKey().getPb(namespace)).build();
        }
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Value && Objects.equals(this.value, ((Value)obj).value);
    }

    public String toString() {
        if (this.value.hasStringValue()) {
            return this.value.getStringValue();
        }
        if (this.value.hasIntegerValue()) {
            return String.valueOf(this.value.getIntegerValue());
        }
        if (this.value.hasDoubleValue()) {
            return String.valueOf(this.value.getDoubleValue());
        }
        if (this.value.hasBooleanValue()) {
            return String.valueOf(this.value.getBooleanValue());
        }
        if (this.value.hasTimestampMicrosecondsValue()) {
            return this.getDate().toString();
        }
        if (this.value.hasBlobValue()) {
            return "<binary>";
        }
        if (this.value.hasEntityValue()) {
            return this.getEntity().toString();
        }
        if (this.value.hasKeyValue()) {
            return this.getKey().toString();
        }
        if (this.value.getListValueCount() > 0) {
            return "[" + this.getList().stream().map(Value::toString).collect(Collectors.joining(", ")) + "]";
        }
        return this.value.toString();
    }

    public static class Builder {
        private final DatastoreV1.Value.Builder value;

        private Builder() {
            this.value = DatastoreV1.Value.newBuilder();
        }

        private Builder(Value value) {
            this(value.getPb());
        }

        private Builder(DatastoreV1.Value value) {
            this.value = DatastoreV1.Value.newBuilder((DatastoreV1.Value)value);
        }

        public Value build() {
            return new Value(this.value.build());
        }

        public Builder value(Object value) {
            if (value instanceof String) {
                this.value.setStringValue((String)value);
            } else if (value instanceof Boolean) {
                this.value.setBooleanValue(((Boolean)value).booleanValue());
            } else if (value instanceof Date) {
                this.value.setTimestampMicrosecondsValue(((Date)value).getTime() * 1000L);
            } else if (value instanceof ByteString) {
                this.value.setBlobValue((ByteString)value);
            } else if (value instanceof Entity) {
                this.value.setEntityValue(((Entity)value).getPb()).setIndexed(false);
            } else if (value instanceof Key) {
                this.value.setKeyValue(((Key)value).getPb());
            } else if (value instanceof Double) {
                this.value.setDoubleValue(((Double)value).doubleValue());
            } else if (value instanceof Long) {
                this.value.setIntegerValue(((Long)value).longValue());
            } else if (value instanceof Float) {
                this.value.setDoubleValue(((Float)value).doubleValue());
            } else if (value instanceof Integer) {
                this.value.setIntegerValue(((Integer)value).longValue());
            } else {
                throw new IllegalArgumentException("Invalid value type.");
            }
            return this;
        }

        public Builder value(List<Object> values) {
            this.value.addAllListValue((Iterable)values.stream().map(value -> Value.builder(value).build().getPb()).collect(Collectors.toList()));
            return this;
        }

        public Builder indexed(boolean indexed) {
            this.value.setIndexed(indexed);
            return this;
        }
    }
}

