/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient.example;

import com.google.api.client.util.Lists;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.common.base.Throwables;
import com.spotify.asyncdatastoreclient.Batch;
import com.spotify.asyncdatastoreclient.Datastore;
import com.spotify.asyncdatastoreclient.DatastoreConfig;
import com.spotify.asyncdatastoreclient.DatastoreException;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Insert;
import com.spotify.asyncdatastoreclient.KeyQuery;
import com.spotify.asyncdatastoreclient.Query;
import com.spotify.asyncdatastoreclient.QueryBuilder;
import com.spotify.asyncdatastoreclient.TransactionResult;
import java.util.Date;
import java.util.List;

public class Example {
    private static void addData(Datastore datastore) {
        Insert insert = QueryBuilder.insert("employee", 1234567L).value("fullname", "Fred Blinge").value("inserted", new Date()).value("age", 40);
        try {
            datastore.execute(insert);
        }
        catch (DatastoreException e) {
            System.err.println("Storage exception: " + Throwables.getRootCause((Throwable)e).getMessage());
        }
    }

    private static void addDataInTransaction(Datastore datastore) {
        try {
            TransactionResult txn = datastore.transaction();
            KeyQuery get = QueryBuilder.query("employee", 2345678L);
            Entity existing = datastore.execute(get, txn).getEntity();
            if (existing != null) {
                datastore.rollback(txn);
            } else {
                Insert insert = QueryBuilder.insert("employee", 2345678L).value("fullname", "Fred Blinge").value("inserted", new Date()).value("age", 40);
                datastore.execute(insert, txn);
            }
        }
        catch (DatastoreException e) {
            System.err.println("Storage exception: " + Throwables.getRootCause((Throwable)e).getMessage());
        }
    }

    private static void queryData(Datastore datastore) {
        Query get = QueryBuilder.query().kindOf("employee").filterBy(QueryBuilder.eq("age", 40)).orderBy(QueryBuilder.asc("fullname"));
        List<Object> entities = Lists.newArrayList();
        try {
            entities = datastore.execute(get).getAll();
        }
        catch (DatastoreException e) {
            System.err.println("Storage exception: " + Throwables.getRootCause((Throwable)e).getMessage());
        }
        for (Entity entity : entities) {
            System.out.println("Employee name: " + entity.getString("fullname"));
            System.out.println("Employee age: " + entity.getInteger("age"));
        }
    }

    private static void deleteData(Datastore datastore) {
        Batch delete = QueryBuilder.batch().add(QueryBuilder.delete("employee", 1234567L)).add(QueryBuilder.delete("employee", 2345678L));
        try {
            datastore.execute(delete);
        }
        catch (DatastoreException e) {
            System.err.println("Storage exception: " + Throwables.getRootCause((Throwable)e).getMessage());
        }
    }

    public static void main(String ... args) throws Exception {
        DatastoreConfig config = DatastoreConfig.builder().connectTimeout(5000).requestTimeout(1000).maxConnections(5).requestRetry(3).dataset("my-dataset").namespace("my-namespace").credential(DatastoreHelper.getComputeEngineCredential()).build();
        Datastore datastore = Datastore.create(config);
        Example.addData(datastore);
        Example.addDataInTransaction(datastore);
        Example.queryData(datastore);
        Example.deleteData(datastore);
        System.out.println("All complete.");
    }
}

