/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.asyncdatastoreclient.example;

import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.spotify.asyncdatastoreclient.Batch;
import com.spotify.asyncdatastoreclient.Datastore;
import com.spotify.asyncdatastoreclient.DatastoreConfig;
import com.spotify.asyncdatastoreclient.Entity;
import com.spotify.asyncdatastoreclient.Insert;
import com.spotify.asyncdatastoreclient.KeyQuery;
import com.spotify.asyncdatastoreclient.MutationResult;
import com.spotify.asyncdatastoreclient.Query;
import com.spotify.asyncdatastoreclient.QueryBuilder;
import com.spotify.asyncdatastoreclient.QueryResult;
import com.spotify.asyncdatastoreclient.TransactionResult;
import java.util.Date;

public class ExampleAsync {
    private static ListenableFuture<MutationResult> addData(Datastore datastore) {
        Insert insert = QueryBuilder.insert("employee", 1234567L).value("fullname", "Fred Blinge").value("inserted", new Date()).value("age", 40);
        return datastore.executeAsync(insert);
    }

    private static ListenableFuture<MutationResult> addDataInTransaction(Datastore datastore) {
        ListenableFuture<TransactionResult> txn = datastore.transactionAsync();
        KeyQuery get = QueryBuilder.query("employee", 2345678L);
        return Futures.transform(datastore.executeAsync(get, txn), result -> {
            if (result.getEntity() == null) {
                datastore.rollbackAsync(txn);
                return Futures.immediateFuture((Object)MutationResult.build());
            }
            Insert insert = QueryBuilder.insert("employee", 2345678L).value("fullname", "Fred Blinge").value("inserted", new Date()).value("age", 40);
            return datastore.executeAsync(insert);
        });
    }

    private static ListenableFuture<QueryResult> queryData(Datastore datastore) {
        Query get = QueryBuilder.query().kindOf("employee").filterBy(QueryBuilder.eq("age", 40)).orderBy(QueryBuilder.asc("fullname"));
        return datastore.executeAsync(get);
    }

    private static ListenableFuture<MutationResult> deleteData(Datastore datastore) {
        Batch delete = QueryBuilder.batch().add(QueryBuilder.delete("employee", 1234567L)).add(QueryBuilder.delete("employee", 2345678L));
        return datastore.executeAsync(delete);
    }

    public static void main(String ... args) throws Exception {
        DatastoreConfig config = DatastoreConfig.builder().connectTimeout(5000).requestTimeout(1000).maxConnections(5).requestRetry(3).dataset("my-dataset").namespace("my-namespace").credential(DatastoreHelper.getComputeEngineCredential()).build();
        Datastore datastore = Datastore.create(config);
        ListenableFuture<MutationResult> addFirst = ExampleAsync.addData(datastore);
        ListenableFuture<MutationResult> addSecond = ExampleAsync.addDataInTransaction(datastore);
        ListenableFuture addBoth = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{addFirst, addSecond});
        ListenableFuture query = Futures.transform((ListenableFuture)addBoth, result -> ExampleAsync.queryData(datastore));
        ListenableFuture delete = Futures.transform((ListenableFuture)query, result -> {
            for (Entity entity : result) {
                System.out.println("Employee name: " + entity.getString("fullname"));
                System.out.println("Employee age: " + entity.getInteger("age"));
            }
            return ExampleAsync.deleteData(datastore);
        });
        Futures.addCallback((ListenableFuture)delete, (FutureCallback)new FutureCallback<MutationResult>(){

            public void onSuccess(MutationResult result) {
                System.out.println("All complete.");
            }

            public void onFailure(Throwable throwable) {
                System.err.println("Storage exception: " + Throwables.getRootCause((Throwable)throwable).getMessage());
            }
        });
    }
}

