/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.featran.numpy;

import com.spotify.featran.numpy.NumPyType;
import java.io.OutputStream;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class NumPy$ {
    public static NumPy$ MODULE$;

    static {
        new NumPy$();
    }

    private String header(Seq<Object> dimensions, NumPyType<?> nt) {
        String dims = dimensions.mkString(", ");
        String shape = dimensions.length() > 1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dims})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dims}));
        String h = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{'descr': '", "', 'fortran_order': False, 'shape': ", ", }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nt.descr(), shape}));
        int l = h.length() + 11;
        int n = l % 16 == 0 ? 0 : (l / 16 + 1) * 16 - l;
        return h + new StringOps(Predef$.MODULE$.augmentString(" ")).$times(n) + "\n";
    }

    public void com$spotify$featran$numpy$NumPy$$writeHeader(OutputStream out, Seq<Object> dimensions, NumPyType<?> nt) {
        out.write(147);
        out.write("NUMPY".getBytes());
        out.write(1);
        out.write(0);
        String headerString = this.header(dimensions, nt);
        int l = headerString.length();
        out.write(0xFF & l);
        out.write(0xFF & l >> 8);
        out.write(headerString.getBytes());
    }

    public <T> void com$spotify$featran$numpy$NumPy$$writeData(OutputStream out, Object data, NumPyType<T> nt) {
        for (int i = 0; i < ScalaRunTime$.MODULE$.array_length(data); ++i) {
            nt.write(out, ScalaRunTime$.MODULE$.array_apply(data, i));
        }
    }

    public <T> void write(OutputStream out, Object data, Seq<Object> shape, NumPyType<T> evidence$1) {
        Seq<Object> seq;
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$1);
        if (shape.isEmpty()) {
            seq = (Seq<Object>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{ScalaRunTime$.MODULE$.array_length(data)}));
        } else {
            Predef$.MODULE$.require(ScalaRunTime$.MODULE$.array_length(data) == BoxesRunTime.unboxToInt((Object)shape.product((Numeric)Numeric.IntIsIntegral$.MODULE$)), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid shape, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shape.mkString(" * "), BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(data))})));
            seq = shape;
        }
        Seq<Object> dims = seq;
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, dims, nt);
        this.com$spotify$featran$numpy$NumPy$$writeData(out, data, nt);
        out.flush();
    }

    public <T> void write(OutputStream out, Iterator<Object> data, int numRows, int numCols, NumPyType<T> evidence$2) {
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$2);
        Seq dims = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{numRows, numCols}));
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, (Seq<Object>)dims, nt);
        IntRef n = IntRef.create((int)0);
        while (data.hasNext()) {
            Object row = data.next();
            Predef$.MODULE$.require(ScalaRunTime$.MODULE$.array_length(row) == numCols, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid row size, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCols), BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(row))})));
            this.com$spotify$featran$numpy$NumPy$$writeData(out, row, nt);
            ++n.elem;
        }
        Predef$.MODULE$.require(n.elem == numRows, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid number of rows, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), BoxesRunTime.boxToInteger((int)n$1.elem)})));
        out.flush();
    }

    public <T> Seq<Object> write$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public void write$mDc$sp(OutputStream out, double[] data, Seq<Object> shape, NumPyType<Object> evidence$1) {
        Seq<Object> seq;
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$1);
        if (shape.isEmpty()) {
            seq = (Seq<Object>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{data.length}));
        } else {
            Predef$.MODULE$.require(data.length == BoxesRunTime.unboxToInt((Object)shape.product((Numeric)Numeric.IntIsIntegral$.MODULE$)), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid shape, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shape.mkString(" * "), BoxesRunTime.boxToInteger((int)data.length)})));
            seq = shape;
        }
        Seq<Object> dims = seq;
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, dims, nt);
        this.com$spotify$featran$numpy$NumPy$$writeData(out, data, nt);
        out.flush();
    }

    public void write$mFc$sp(OutputStream out, float[] data, Seq<Object> shape, NumPyType<Object> evidence$1) {
        Seq<Object> seq;
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$1);
        if (shape.isEmpty()) {
            seq = (Seq<Object>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{data.length}));
        } else {
            Predef$.MODULE$.require(data.length == BoxesRunTime.unboxToInt((Object)shape.product((Numeric)Numeric.IntIsIntegral$.MODULE$)), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid shape, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shape.mkString(" * "), BoxesRunTime.boxToInteger((int)data.length)})));
            seq = shape;
        }
        Seq<Object> dims = seq;
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, dims, nt);
        this.com$spotify$featran$numpy$NumPy$$writeData(out, data, nt);
        out.flush();
    }

    public void write$mIc$sp(OutputStream out, int[] data, Seq<Object> shape, NumPyType<Object> evidence$1) {
        Seq<Object> seq;
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$1);
        if (shape.isEmpty()) {
            seq = (Seq<Object>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{data.length}));
        } else {
            Predef$.MODULE$.require(data.length == BoxesRunTime.unboxToInt((Object)shape.product((Numeric)Numeric.IntIsIntegral$.MODULE$)), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid shape, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shape.mkString(" * "), BoxesRunTime.boxToInteger((int)data.length)})));
            seq = shape;
        }
        Seq<Object> dims = seq;
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, dims, nt);
        this.com$spotify$featran$numpy$NumPy$$writeData(out, data, nt);
        out.flush();
    }

    public void write$mJc$sp(OutputStream out, long[] data, Seq<Object> shape, NumPyType<Object> evidence$1) {
        Seq<Object> seq;
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$1);
        if (shape.isEmpty()) {
            seq = (Seq<Object>)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{data.length}));
        } else {
            Predef$.MODULE$.require(data.length == BoxesRunTime.unboxToInt((Object)shape.product((Numeric)Numeric.IntIsIntegral$.MODULE$)), (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid shape, ", " != ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shape.mkString(" * "), BoxesRunTime.boxToInteger((int)data.length)})));
            seq = shape;
        }
        Seq<Object> dims = seq;
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, dims, nt);
        this.com$spotify$featran$numpy$NumPy$$writeData(out, data, nt);
        out.flush();
    }

    public void write$mDc$sp(OutputStream out, Iterator<double[]> data, int numRows, int numCols, NumPyType<Object> evidence$2) {
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$2);
        Seq dims = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{numRows, numCols}));
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, (Seq<Object>)dims, nt);
        IntRef n = IntRef.create((int)0);
        while (data.hasNext()) {
            double[] row = (double[])data.next();
            Predef$.MODULE$.require(row.length == numCols, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid row size, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCols), BoxesRunTime.boxToInteger((int)row.length)})));
            this.com$spotify$featran$numpy$NumPy$$writeData(out, row, nt);
            ++n.elem;
        }
        Predef$.MODULE$.require(n.elem == numRows, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid number of rows, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), BoxesRunTime.boxToInteger((int)n$2.elem)})));
        out.flush();
    }

    public void write$mFc$sp(OutputStream out, Iterator<float[]> data, int numRows, int numCols, NumPyType<Object> evidence$2) {
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$2);
        Seq dims = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{numRows, numCols}));
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, (Seq<Object>)dims, nt);
        IntRef n = IntRef.create((int)0);
        while (data.hasNext()) {
            float[] row = (float[])data.next();
            Predef$.MODULE$.require(row.length == numCols, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid row size, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCols), BoxesRunTime.boxToInteger((int)row.length)})));
            this.com$spotify$featran$numpy$NumPy$$writeData(out, row, nt);
            ++n.elem;
        }
        Predef$.MODULE$.require(n.elem == numRows, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid number of rows, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), BoxesRunTime.boxToInteger((int)n$3.elem)})));
        out.flush();
    }

    public void write$mIc$sp(OutputStream out, Iterator<int[]> data, int numRows, int numCols, NumPyType<Object> evidence$2) {
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$2);
        Seq dims = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{numRows, numCols}));
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, (Seq<Object>)dims, nt);
        IntRef n = IntRef.create((int)0);
        while (data.hasNext()) {
            int[] row = (int[])data.next();
            Predef$.MODULE$.require(row.length == numCols, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid row size, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCols), BoxesRunTime.boxToInteger((int)row.length)})));
            this.com$spotify$featran$numpy$NumPy$$writeData(out, row, nt);
            ++n.elem;
        }
        Predef$.MODULE$.require(n.elem == numRows, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid number of rows, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), BoxesRunTime.boxToInteger((int)n$4.elem)})));
        out.flush();
    }

    public void write$mJc$sp(OutputStream out, Iterator<long[]> data, int numRows, int numCols, NumPyType<Object> evidence$2) {
        NumPyType nt = (NumPyType)Predef$.MODULE$.implicitly(evidence$2);
        Seq dims = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{numRows, numCols}));
        this.com$spotify$featran$numpy$NumPy$$writeHeader(out, (Seq<Object>)dims, nt);
        IntRef n = IntRef.create((int)0);
        while (data.hasNext()) {
            long[] row = (long[])data.next();
            Predef$.MODULE$.require(row.length == numCols, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid row size, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCols), BoxesRunTime.boxToInteger((int)row.length)})));
            this.com$spotify$featran$numpy$NumPy$$writeData(out, row, nt);
            ++n.elem;
        }
        Predef$.MODULE$.require(n.elem == numRows, (Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid number of rows, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), BoxesRunTime.boxToInteger((int)n$5.elem)})));
        out.flush();
    }

    private NumPy$() {
        MODULE$ = this;
    }
}

