/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.InstrumentedContext;
import com.spotify.flo.context.Logging;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ChainedListener
implements InstrumentedContext.Listener {
    private final InstrumentedContext.Listener first;
    private final InstrumentedContext.Listener second;
    private final Logging logging;

    ChainedListener(InstrumentedContext.Listener first, InstrumentedContext.Listener second, Logging logging) {
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
        this.logging = Objects.requireNonNull(logging);
    }

    public void task(Task<?> task) {
        this.guardedCall(() -> this.first.task(task));
        this.guardedCall(() -> this.second.task(task));
    }

    public void status(TaskId taskId, InstrumentedContext.Listener.Phase phase) {
        this.guardedCall(() -> this.first.status(taskId, phase));
        this.guardedCall(() -> this.second.status(taskId, phase));
    }

    private void guardedCall(Runnable call) {
        try {
            call.run();
        }
        catch (Throwable t) {
            this.logging.exception(t);
        }
    }

    public void close() throws IOException {
        List exceptions = Stream.of(this.first, this.second).map(this::close).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            throw (IOException)exceptions.get(0);
        }
    }

    private Optional<IOException> close(InstrumentedContext.Listener listener) {
        try {
            listener.close();
        }
        catch (IOException e) {
            this.logging.exception(e);
            return Optional.of(e);
        }
        return Optional.empty();
    }
}

