/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Task;
import com.spotify.flo.TaskInfo;
import com.spotify.flo.context.ChainedListener;
import com.spotify.flo.context.FloListenerFactory;
import com.spotify.flo.context.InstrumentedContext;
import com.spotify.flo.context.Logging;
import com.spotify.flo.context.LoggingContext;
import com.spotify.flo.context.MemoizingContext;
import com.spotify.flo.context.NoopListener;
import com.spotify.flo.context.OverridingContext;
import com.spotify.flo.freezer.Persisted;
import com.spotify.flo.freezer.PersistingContext;
import com.spotify.flo.status.NotReady;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FloRunner<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FloRunner.class);
    private final Logging logging = Logging.create(LOG);
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();
    private final Config config;
    private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyz0123456789";

    private FloRunner(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    private static Config defaultConfig() {
        return ConfigFactory.load((String)"flo");
    }

    public static <T> Result<T> runTask(Task<T> task, Config config) {
        return new Result<T>(super.run(task));
    }

    public static <T> Result<T> runTask(Task<T> task) {
        return FloRunner.runTask(task, FloRunner.defaultConfig());
    }

    private Future<T> run(Task<T> task) {
        this.logging.header();
        if (this.isMode("tree")) {
            this.logging.tree(TaskInfo.ofTask(task));
            return CompletableFuture.completedFuture(null);
        }
        this.logging.printPlan(TaskInfo.ofTask(task));
        EvalContext evalContext = this.createContext();
        long t0 = System.nanoTime();
        EvalContext.Value value = evalContext.evaluate(task);
        CompletableFuture future = new CompletableFuture();
        value.consume(future::complete);
        value.onFail(future::completeExceptionally);
        return future.handle((v, throwable) -> {
            new Thread(() -> this.closeables.forEach(closeable -> {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    LOG.warn("could not close {}", closeable.getClass(), (Object)e);
                }
            }), "flo-runner-closer").start();
            if (throwable != null) {
                this.logging.exception((Throwable)throwable);
                this.logging.complete(task.id(), Duration.ofNanos(System.nanoTime() - t0));
                throw new CompletionException((Throwable)throwable);
            }
            this.logging.complete(task.id(), Duration.ofNanos(System.nanoTime() - t0));
            return v;
        });
    }

    private EvalContext createContext() {
        EvalContext instrumentedContext = this.instrument(this.createRootContext());
        EvalContext baseContext = this.isMode("persist") ? this.persist(instrumentedContext) : instrumentedContext;
        return MemoizingContext.composeWith((EvalContext)OverridingContext.composeWith(LoggingContext.composeWith(baseContext, this.logging), this.logging));
    }

    private EvalContext createRootContext() {
        if (this.config.getBoolean("flo.async")) {
            AtomicLong count = new AtomicLong(0L);
            ThreadFactory threadFactory = runnable -> {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName("flo-worker-" + count.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            };
            ExecutorService executor = Executors.newFixedThreadPool(this.config.getInt("flo.workers"), threadFactory);
            this.closeables.add(FloRunner.executorCloser(executor));
            return EvalContext.async((Executor)executor);
        }
        return EvalContext.sync();
    }

    private EvalContext instrument(EvalContext delegate) {
        ServiceLoader<FloListenerFactory> factories = ServiceLoader.load(FloListenerFactory.class);
        Object listener = new NoopListener();
        for (FloListenerFactory factory : factories) {
            InstrumentedContext.Listener newListener = Objects.requireNonNull(factory.createListener(this.config));
            listener = new ChainedListener(newListener, (InstrumentedContext.Listener)listener, this.logging);
        }
        this.closeables.add((Closeable)listener);
        return InstrumentedContext.composeWith((EvalContext)delegate, (InstrumentedContext.Listener)listener);
    }

    private EvalContext persist(EvalContext delegate) {
        String stateLocation = this.config.hasPath("flo.state.location") ? this.config.getString("flo.state.location") : "file://" + System.getProperty("user.dir");
        URI basePathUri = URI.create(stateLocation);
        Path basePath = Paths.get(basePathUri).resolve("run-" + FloRunner.randomAlphaNumeric(4));
        try {
            Files.createDirectories(basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new PersistingContext(basePath, delegate);
    }

    private boolean isMode(String mode) {
        return mode.equalsIgnoreCase(this.config.getString("mode"));
    }

    private static Closeable executorCloser(ExecutorService executorService) {
        return () -> {
            boolean terminated;
            executorService.shutdown();
            try {
                terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                terminated = false;
            }
            if (!terminated) {
                executorService.shutdownNow();
            }
        };
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public static class Result<T> {
        private final Future<T> future;

        Result(Future<T> future) {
            this.future = future;
        }

        public Future<T> future() {
            return this.future;
        }

        public void waitAndExit() {
            this.waitAndExit(System::exit);
        }

        public T value() throws ExecutionException, InterruptedException {
            return this.future.get();
        }

        void waitAndExit(Consumer<Integer> exiter) {
            try {
                this.future.get();
                exiter.accept(0);
            }
            catch (ExecutionException e) {
                int status = e.getCause() instanceof NotReady ? 20 : (e.getCause() instanceof Persisted ? 0 : 1);
                exiter.accept(status);
            }
            catch (InterruptedException | RuntimeException e) {
                exiter.accept(1);
            }
        }
    }
}

