/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.Logging;
import java.time.Duration;
import java.util.Objects;

class LoggingContext
implements EvalContext {
    private final EvalContext baseContext;
    private final Logging logging;

    private LoggingContext(EvalContext baseContext, Logging logging) {
        this.baseContext = Objects.requireNonNull(baseContext);
        this.logging = Objects.requireNonNull(logging);
    }

    static EvalContext composeWith(EvalContext baseContext, Logging logging) {
        return new LoggingContext(baseContext, logging);
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        this.logging.willEval(task.id());
        return this.baseContext.evaluateInternal(task, context);
    }

    public <T> EvalContext.Value<T> invokeProcessFn(TaskId taskId, Fn<EvalContext.Value<T>> processFn) {
        this.logging.startEval(taskId);
        long t0 = System.nanoTime();
        EvalContext.Value tValue = this.baseContext.invokeProcessFn(taskId, processFn);
        tValue.consume(v -> this.logging.completedValue(taskId, v, Duration.ofNanos(System.nanoTime() - t0)));
        tValue.onFail(valueError -> this.logging.failedValue(taskId, (Throwable)valueError, Duration.ofNanos(System.nanoTime() - t0)));
        return tValue;
    }

    public <T> EvalContext.Value<T> value(Fn<T> fn) {
        return this.baseContext.value(fn);
    }

    public <T> EvalContext.Promise<T> promise() {
        return this.baseContext.promise();
    }
}

