/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.EvalContext;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContextStrict;
import com.spotify.flo.context.ForwardingEvalContext;
import com.spotify.flo.context.Logging;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverridingContext
extends ForwardingEvalContext {
    private static final Logger LOG = LoggerFactory.getLogger(OverridingContext.class);
    private final Logging logging;

    private OverridingContext(EvalContext delegate, Logging logging) {
        super(delegate);
        this.logging = logging;
    }

    public static EvalContext composeWith(EvalContext baseContext, Logging logging) {
        return new OverridingContext(baseContext, logging);
    }

    public <T> EvalContext.Value<T> evaluateInternal(Task<T> task, EvalContext context) {
        Optional<TaskContextStrict> taskContextStrict = task.contexts().stream().filter(c -> c instanceof TaskContextStrict).map(c -> (TaskContextStrict)c).findFirst();
        if (taskContextStrict.isPresent()) {
            return context.value((Fn & Serializable)() -> ((TaskContextStrict)taskContextStrict.get()).lookup(task)).flatMap(value -> {
                if (value.isPresent()) {
                    Object t = value.get();
                    LOG.debug("Not expanding {}, lookup = {}", (Object)task.id(), t);
                    this.logging.overriddenValue(task.id(), t);
                    return context.immediateValue(t);
                }
                LOG.debug("Lookup not found, expanding {}", (Object)task.id());
                this.logging.overriddenValueNotFound(task.id());
                return this.delegate.evaluateInternal(task, context);
            });
        }
        LOG.debug("Expanding {}", (Object)task.id());
        return this.delegate.evaluateInternal(task, context);
    }
}

