/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.util;

import com.spotify.flo.util.AutoValue_Date;
import com.spotify.flo.util.DateHour;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public abstract class Date
implements Comparable<Date>,
Serializable {
    private static final DateTimeFormatter ISO_FRAGMENT_FMT = DateTimeFormatter.ofPattern("uuuu-MM-dd");

    public abstract LocalDate localDate();

    public static Date of(LocalDate date) {
        return new AutoValue_Date(date);
    }

    public static Date of(int year, int month, int day) {
        return Date.of(LocalDate.of(year, month, day));
    }

    public static Date parse(String date) {
        return Date.parse(date, ISO_FRAGMENT_FMT);
    }

    public static Date valueOf(String date) {
        return Date.parse(date, ISO_FRAGMENT_FMT);
    }

    public static Date parse(String date, DateTimeFormatter formatter) {
        return Date.of(formatter.parse((CharSequence)date, LocalDate::from));
    }

    public DateHour onHour(int hour) {
        return DateHour.of(this, hour);
    }

    public String format(DateTimeFormatter formatter) {
        return formatter.format(this.localDate());
    }

    public String toString() {
        return ISO_FRAGMENT_FMT.format(this.localDate());
    }

    @Override
    public int compareTo(Date other) {
        return this.localDate().compareTo(other.localDate());
    }
}

