/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.scio;

import com.spotify.flo.EvalContext;
import com.spotify.flo.FloTesting;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import com.spotify.flo.TaskOperator;
import com.spotify.flo.contrib.scio.ScioJobSpec;
import com.spotify.flo.contrib.scio.ScioOperator$;
import com.spotify.scio.ScioContext;
import com.spotify.scio.ScioContext$;
import com.spotify.scio.ScioResult;
import com.spotify.scio.testing.JobTest;
import com.spotify.scio.testing.JobTest$;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u00015\u0011AbU2j_>\u0003XM]1u_JT!a\u0001\u0003\u0002\tM\u001c\u0017n\u001c\u0006\u0003\u000b\u0019\tqaY8oiJL'M\u0003\u0002\b\u0011\u0005\u0019a\r\\8\u000b\u0005%Q\u0011aB:q_RLg-\u001f\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001U\u0011a\"J\n\u0004\u0001=9\u0002C\u0001\t\u0016\u001b\u0005\t\"B\u0001\n\u0014\u0003\u0011a\u0017M\\4\u000b\u0003Q\tAA[1wC&\u0011a#\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u000baI2$M\u0012\u000e\u0003\u0019I!A\u0007\u0004\u0003\u0019Q\u000b7o[(qKJ\fGo\u001c:\u0011\u0007q\u00013E\u0004\u0002\u001e=5\t!!\u0003\u0002 \u0005\u0005Y1kY5p\u0015>\u00147\u000b]3d\u0013\t\t#E\u0001\u0005Qe>4\u0018\u000eZ3s\u0015\ty\"\u0001\u0005\u0002%K1\u0001A!\u0002\u0014\u0001\u0005\u00049#!\u0001+\u0012\u0005!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#a\u0002(pi\"Lgn\u001a\t\u0003S=J!\u0001\r\u0016\u0003\u0007\u0005s\u0017\u0010\r\u00023mA!QdM\u001b$\u0013\t!$AA\u0006TG&|'j\u001c2Ta\u0016\u001c\u0007C\u0001\u00137\t%9\u0004!!A\u0001\u0002\u000b\u0005qEA\u0002`IEBQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtD#A\u001e\u0011\u0007u\u00011\u0005C\u0003>\u0001\u0011\u0005a(A\u0004qe>4\u0018\u000eZ3\u0015\u0005my\u0004\"\u0002!=\u0001\u0004\t\u0015aC3wC2\u001cuN\u001c;fqR\u0004\"\u0001\u0007\"\n\u0005\r3!aC#wC2\u001cuN\u001c;fqRDQ!\u0012\u0001\u0005B\u0019\u000bq\u0001]3sM>\u0014X\u000eF\u0002$\u000f:CQ\u0001\u0013#A\u0002%\u000bAa\u001d9fGB\u0012!\n\u0014\t\u0005;MZ5\u0005\u0005\u0002%\u0019\u0012IQjRA\u0001\u0002\u0003\u0015\ta\n\u0002\u0004?\u0012\u0012\u0004\"B(E\u0001\u0004\u0001\u0016\u0001\u00037jgR,g.\u001a:\u0011\u0005E#fB\u0001\rS\u0013\t\u0019f!\u0001\u0007UCN\\w\n]3sCR|'/\u0003\u0002V-\nAA*[:uK:,'O\u0003\u0002T\r!)\u0001\f\u0001C\u00053\u00069!/\u001e8UKN$XC\u0001._)\t\u00193\fC\u0003I/\u0002\u0007A\f\u0005\u0003\u001egu\u001b\u0003C\u0001\u0013_\t\u0015yvK1\u0001(\u0005\u0005\u0011\u0006\"B1\u0001\t\u0013\u0011\u0017AE:dS>\u001cuN\u001c;fqR4uN\u001d+fgR,2aYA\u0006)\r!\u0017\u000e\u001f\t\u0003K\u001el\u0011A\u001a\u0006\u0003\u0007!I!\u0001\u001b4\u0003\u0017M\u001b\u0017n\\\"p]R,\u0007\u0010\u001e\u0005\u0006U\u0002\u0004\ra[\u0001\b_B$\u0018n\u001c8t!\tag/D\u0001n\u0015\tQgN\u0003\u0002pa\u0006\u00191\u000fZ6\u000b\u0005E\u0014\u0018\u0001\u00022fC6T!a\u001d;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0018aA8sO&\u0011q/\u001c\u0002\u0010!&\u0004X\r\\5oK>\u0003H/[8og\")\u0011\u0010\u0019a\u0001u\u00061A/Z:u\u0013\u0012\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{*j\u0011A \u0006\u0003\u007f2\ta\u0001\u0010:p_Rt\u0014bAA\u0002U\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001+\t\u0019\ti\u0001\u0019b\u0001O\t\tQ\u000bC\u0004\u0002\u0012\u0001!I!a\u0005\u0002\u000fI,h\u000e\u0015:pIV!\u0011QCA\u000f)\u0015\u0019\u0013qCA\u0010\u0011\u001dA\u0015q\u0002a\u0001\u00033\u0001R!H\u001a\u0002\u001c\r\u00022\u0001JA\u000f\t\u0019y\u0016q\u0002b\u0001O!1q*a\u0004A\u0002ACq!a\t\u0001\t\u0013\t)#A\tsKB|'\u000f\u001e#bi\u00064Gn\\<K_\n$\u0002\"a\n\u0002.\u0005]\u00121\n\t\u0004S\u0005%\u0012bAA\u0016U\t!QK\\5u\u0011!\ty#!\tA\u0002\u0005E\u0012A\u0002;bg.LE\rE\u0002\u0019\u0003gI1!!\u000e\u0007\u0005\u0019!\u0016m]6JI\"A\u0011\u0011HA\u0011\u0001\u0004\tY$A\u0002k_\n\u0004B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0005eCR\fg\r\\8x\u0015\r\t)\u0005]\u0001\beVtg.\u001a:t\u0013\u0011\tI%a\u0010\u0003'\u0011\u000bG/\u00194m_^\u0004\u0016\u000e]3mS:,'j\u001c2\t\r=\u000b\t\u00031\u0001Q\u0011\u001d\ty\u0005\u0001C\u0005\u0003#\nA\u0004Z1uC\u001adwn\u001e&pE6{g.\u001b;pe&tw\rU1hKV\u0013F\nF\u0002{\u0003'B\u0001\"!\u000f\u0002N\u0001\u0007\u00111\b\u0015\b\u0001\u0005]\u0013QLA0!\rI\u0013\u0011L\u0005\u0004\u00037R#\u0001E*fe&\fGNV3sg&|g.V%E\u0003\u00151\u0018\r\\;f=\u0005\tqaBA2\u0005!\u0005\u0011QM\u0001\r'\u000eLwn\u00149fe\u0006$xN\u001d\t\u0004;\u0005\u001ddAB\u0001\u0003\u0011\u0003\tIg\u0005\u0004\u0002h\u0005-\u0014\u0011\u000f\t\u0004S\u00055\u0014bAA8U\t1\u0011I\\=SK\u001a\u00042!KA:\u0013\r\t)H\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bs\u0005\u001dD\u0011AA=)\t\t)\u0007\u0003\u0006\u0002~\u0005\u001d$\u0019!C\u0005\u0003\u007f\n1\u0001\\8h+\t\t\t\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9\t^\u0001\u0006g24GG[\u0005\u0005\u0003\u0017\u000b)I\u0001\u0004M_\u001e<WM\u001d\u0005\n\u0003\u001f\u000b9\u0007)A\u0005\u0003\u0003\u000bA\u0001\\8hA!Q\u00111SA4\u0005\u0004%I!!&\u0002\t5{5iS\u000b\u0003\u0003/\u0003b!!'\u0002 \u0006\u0015fb\u0001\r\u0002\u001c&\u0019\u0011Q\u0014\u0004\u0002\u0017Q+7\u000f^\"p]R,\u0007\u0010^\u0005\u0005\u0003C\u000b\u0019KA\u0002LKfT1!!(\u0007!\u0011\t9+!+\u000e\u0005\u0005\u001ddaBAV\u0003O\u0002\u0011Q\u0016\u0002\b\u001b>\u001c7.\u001b8h'\u0011\tI+a\u001b\t\u000fe\nI\u000b\"\u0001\u00022R\u0011\u0011Q\u0015\u0005\f\u0003k\u000bIK1A\u0005\u0002\t\t9,A\u0004sKN,H\u000e^:\u0016\u0005\u0005e\u0006cBA^\u0003\u000b\f\tDL\u0007\u0003\u0003{SA!a0\u0002B\u00069Q.\u001e;bE2,'bAAbU\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0017Q\u0018\u0002\u0004\u001b\u0006\u0004\b\"CAf\u0003S\u0003\u000b\u0011BA]\u0003!\u0011Xm];miN\u0004\u0003bCAh\u0003S\u0013\r\u0011\"\u0001\u0003\u0003#\f\u0001B[8c)\u0016\u001cHo]\u000b\u0003\u0003'\u0004\u0002\"a/\u0002F\u0006E\u0012Q\u001b\t\u0006S\u0005]\u00171\\\u0005\u0004\u00033T#!\u0003$v]\u000e$\u0018n\u001c81!\u0011\ti.!;\u000f\t\u0005}\u0017Q]\u0007\u0003\u0003CT1!a9g\u0003\u001d!Xm\u001d;j]\u001eLA!a:\u0002b\u00069!j\u001c2UKN$\u0018\u0002BAv\u0003[\u0014qAQ;jY\u0012,'O\u0003\u0003\u0002h\u0006\u0005\b\"CAy\u0003S\u0003\u000b\u0011BAj\u0003%QwN\u0019+fgR\u001c\b\u0005\u0003\u0005\u0002v\u0006%F\u0011AA|\u0003\u0019\u0011Xm];miR1\u0011QUA}\u0003{D\u0001\"a?\u0002t\u0002\u0007\u0011\u0011G\u0001\u0003S\u0012Dq!!>\u0002t\u0002\u0007a\u0006\u0003\u0005\u0003\u0002\u0005%F\u0011\u0001B\u0002\u0003\u001dQwN\u0019+fgR$BA!\u0002\u00030Q!!q\u0001B\u0013)\u0011\t)K!\u0003\t\u0011\t-\u0011q a\u0002\u0005\u001b\t!AY7\u0011\t\t=!\u0011\u0005\b\u0005\u0005#\t)O\u0004\u0003\u0003\u0014\t}a\u0002\u0002B\u000b\u0005;qAAa\u0006\u0003\u001c9\u0019QP!\u0007\n\u0003-I!!\u0003\u0006\n\u0005\rA\u0011bAArM&!!1EAw\u0005-\u0011U-Y7PaRLwN\\:\t\u0011\t\u001d\u0012q a\u0001\u0005S\tQa]3ukB\u0004r!\u000bB\u0016\u00037\fY.C\u0002\u0003.)\u0012\u0011BR;oGRLwN\\\u0019\t\u0011\u0005m\u0018q a\u0001\u0003cA\u0011Ba\r\u0002h\u0001\u0006I!a&\u0002\u000b5{5i\u0013\u0011\t\u0011\t]\u0012q\rC\u0001\u0003c\u000bA!\\8dW\"A!1HA4\t\u0003\u0011i$A\u0003baBd\u00170\u0006\u0003\u0003@\t\u0015CC\u0001B!!\u0011i\u0002Aa\u0011\u0011\u0007\u0011\u0012)\u0005\u0002\u0004'\u0005s\u0011\ra\n\u0005\u000b\u0005\u0013\n9'!A\u0005\n\t-\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012a\u0004")
public class ScioOperator<T>
implements TaskOperator<ScioJobSpec.Provider<T>, ScioJobSpec<?, T>, T> {
    public static final long serialVersionUID = 1L;

    public static <T> ScioOperator<T> apply() {
        return ScioOperator$.MODULE$.apply();
    }

    public static Mocking mock() {
        return ScioOperator$.MODULE$.mock();
    }

    public ScioJobSpec.Provider<T> provide(EvalContext evalContext) {
        return new ScioJobSpec.Provider(((Task)evalContext.currentTask().get()).id());
    }

    public T perform(ScioJobSpec<?, T> spec, TaskOperator.Listener listener) {
        spec.validate();
        return FloTesting.isTest() ? this.runTest(spec) : this.runProd(spec, listener);
    }

    private <R> T runTest(ScioJobSpec<R, T> spec) {
        Object object = new Object();
        try {
            ScioOperator$.MODULE$.mock().results().get((Object)spec.taskId()).foreach((Function1 & Serializable & scala.Serializable)result -> {
                throw new NonLocalReturnControl(object, spec.success().apply(result));
            });
            ScioOperator$.MODULE$.mock().jobTests().get((Object)spec.taskId()).foreach((Function1 & Serializable & scala.Serializable)jobTestSupplier -> {
                Try scioResult;
                JobTest.Builder jobTest = (JobTest.Builder)jobTestSupplier.apply();
                jobTest.setUp();
                ScioContext sc = this.scioContextForTest((PipelineOptions)spec.options().apply(), jobTest.testId());
                spec.pipeline().apply((Object)sc);
                Try try_ = scioResult = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sc.close());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    throw new NonLocalReturnControl(object, spec.failure().apply((Object)t));
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Try done = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ScioResult qual$1 = (ScioResult)scioResult.get();
                    Duration x$1 = qual$1.waitUntilDone$default$1();
                    boolean x$2 = qual$1.waitUntilDone$default$2();
                    return qual$1.waitUntilDone(x$1, x$2);
                });
                Try try_2 = done;
                if (try_2 instanceof Failure) {
                    Failure failure = (Failure)try_2;
                    Throwable t = failure.exception();
                    throw new NonLocalReturnControl(object, spec.failure().apply((Object)t));
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> spec.result().apply((Object)sc.options(), scioResult.get()));
                Try try_3 = result;
                if (try_3 instanceof Failure) {
                    Failure failure = (Failure)try_3;
                    Throwable t = failure.exception();
                    throw new NonLocalReturnControl(object, spec.failure().apply((Object)t));
                }
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                jobTest.tearDown();
                throw new NonLocalReturnControl(object, spec.success().apply(result.get()));
            });
            throw new AssertionError((Object)"Missing either mocked scio job result or JobTest, please set them up using either ScioOperator.mock().result(...) or ScioOperator.mock().result().jobTest(...) before running the workflow");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (T)ex.value();
        }
    }

    private <U> ScioContext scioContextForTest(PipelineOptions options, String testId) {
        Class<?> runner = Class.forName("org.apache.beam.runners.direct.DirectRunner");
        options.setRunner(runner);
        ((ApplicationNameOptions)options.as(ApplicationNameOptions.class)).setAppName(testId);
        ScioContext sc = ScioContext$.MODULE$.apply(options);
        if (!sc.isTest()) {
            throw new AssertionError((Object)new StringBuilder(46).append("Failed to create ScioContext for test with id ").append(testId).toString());
        }
        return sc;
    }

    private <R> T runProd(ScioJobSpec<R, T> spec, TaskOperator.Listener listener) {
        Try done;
        Try scioResult;
        ScioContext sc = ScioContext$.MODULE$.apply((PipelineOptions)spec.options().apply());
        spec.pipeline().apply((Object)sc);
        Try try_ = scioResult = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sc.close());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return (T)spec.failure().apply((Object)t);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        PipelineResult pipelineResult = ((ScioResult)scioResult.get()).internal();
        if (pipelineResult instanceof DataflowPipelineJob) {
            DataflowPipelineJob dataflowPipelineJob = (DataflowPipelineJob)pipelineResult;
            this.reportDataflowJob(spec.taskId(), dataflowPipelineJob, listener);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        }
        Try try_2 = done = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ScioResult qual$2 = (ScioResult)scioResult.get();
            Duration x$3 = qual$2.waitUntilDone$default$1();
            boolean x$4 = qual$2.waitUntilDone$default$2();
            return qual$2.waitUntilDone(x$3, x$4);
        });
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable t = failure.exception();
            return (T)spec.failure().apply((Object)t);
        }
        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> spec.result().apply((Object)sc.options(), scioResult.get()));
        Try try_3 = result;
        if (try_3 instanceof Failure) {
            Failure failure = (Failure)try_3;
            Throwable t = failure.exception();
            return (T)spec.failure().apply((Object)t);
        }
        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        return (T)spec.success().apply(result.get());
    }

    private void reportDataflowJob(TaskId taskId, DataflowPipelineJob job, TaskOperator.Listener listener) {
        String url = this.dataflowJobMonitoringPageURL(job);
        scala.collection.immutable.Map jobMeta = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job-type"), (Object)"dataflow"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"job-id"), (Object)job.getJobId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"project-id"), (Object)job.getProjectId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), (Object)job.getRegion()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"monitoring-page-url"), (Object)url)}));
        ScioOperator$.MODULE$.com$spotify$flo$contrib$scio$ScioOperator$$log().info("Started scio job (dataflow): {}", new Object[]{jobMeta});
        listener.meta(taskId, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobMeta).asJava());
    }

    private String dataflowJobMonitoringPageURL(DataflowPipelineJob job) {
        return String.format("https://console.cloud.google.com/dataflow/jobsDetail/locations/%s/jobs/%s?project=%s", URLEncoder.encode(job.getRegion(), StandardCharsets.UTF_8.name()), URLEncoder.encode(job.getJobId(), StandardCharsets.UTF_8.name()), URLEncoder.encode(job.getProjectId(), StandardCharsets.UTF_8.name()));
    }

    public static class Mocking {
        private final scala.collection.mutable.Map<TaskId, Object> results = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<TaskId, Function0<JobTest.Builder>> jobTests = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public scala.collection.mutable.Map<TaskId, Object> results() {
            return this.results;
        }

        public scala.collection.mutable.Map<TaskId, Function0<JobTest.Builder>> jobTests() {
            return this.jobTests;
        }

        public Mocking result(TaskId id, Object result) {
            this.results().update((Object)id, result);
            return this;
        }

        public Mocking jobTest(TaskId id, Function1<JobTest.Builder, JobTest.Builder> setup, JobTest.BeamOptions bm) {
            this.jobTests().update((Object)id, (Function0 & Serializable & scala.Serializable)() -> {
                String name = id.toString().replace("-", "_");
                JobTest.Builder builder = JobTest$.MODULE$.apply(name, bm);
                setup.apply((Object)builder);
                return builder;
            });
            return this;
        }
    }
}

