/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import com.spotify.flo.contrib.styx.StructuredLogMessage;
import io.norberg.automatter.AutoMatter;

final class StructuredLogMessageBuilder {
    private String time;
    private String severity;
    private String logger;
    private String thread;
    private String message;
    private StructuredLogMessage.Workflow workflow;

    public StructuredLogMessageBuilder() {
    }

    private StructuredLogMessageBuilder(StructuredLogMessage v) {
        this.time = v.time();
        this.severity = v.severity();
        this.logger = v.logger();
        this.thread = v.thread();
        this.message = v.message();
        this.workflow = v.workflow();
    }

    private StructuredLogMessageBuilder(StructuredLogMessageBuilder v) {
        this.time = v.time;
        this.severity = v.severity;
        this.logger = v.logger;
        this.thread = v.thread;
        this.message = v.message;
        this.workflow = v.workflow;
    }

    public String time() {
        return this.time;
    }

    public StructuredLogMessageBuilder time(String time) {
        if (time == null) {
            throw new NullPointerException("time");
        }
        this.time = time;
        return this;
    }

    public String severity() {
        return this.severity;
    }

    public StructuredLogMessageBuilder severity(String severity) {
        if (severity == null) {
            throw new NullPointerException("severity");
        }
        this.severity = severity;
        return this;
    }

    public String logger() {
        return this.logger;
    }

    public StructuredLogMessageBuilder logger(String logger) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        this.logger = logger;
        return this;
    }

    public String thread() {
        return this.thread;
    }

    public StructuredLogMessageBuilder thread(String thread) {
        if (thread == null) {
            throw new NullPointerException("thread");
        }
        this.thread = thread;
        return this;
    }

    public String message() {
        return this.message;
    }

    public StructuredLogMessageBuilder message(String message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
        return this;
    }

    public StructuredLogMessage.Workflow workflow() {
        return this.workflow;
    }

    public StructuredLogMessageBuilder workflow(StructuredLogMessage.Workflow workflow) {
        if (workflow == null) {
            throw new NullPointerException("workflow");
        }
        this.workflow = workflow;
        return this;
    }

    public StructuredLogMessage build() {
        return new Value(this.time, this.severity, this.logger, this.thread, this.message, this.workflow);
    }

    public static StructuredLogMessageBuilder from(StructuredLogMessage v) {
        return new StructuredLogMessageBuilder(v);
    }

    public static StructuredLogMessageBuilder from(StructuredLogMessageBuilder v) {
        return new StructuredLogMessageBuilder(v);
    }

    private static final class Value
    implements StructuredLogMessage {
        private final String time;
        private final String severity;
        private final String logger;
        private final String thread;
        private final String message;
        private final StructuredLogMessage.Workflow workflow;

        private Value(@AutoMatter.Field(value="time") String time, @AutoMatter.Field(value="severity") String severity, @AutoMatter.Field(value="logger") String logger, @AutoMatter.Field(value="thread") String thread, @AutoMatter.Field(value="message") String message, @AutoMatter.Field(value="workflow") StructuredLogMessage.Workflow workflow) {
            if (time == null) {
                throw new NullPointerException("time");
            }
            if (severity == null) {
                throw new NullPointerException("severity");
            }
            if (logger == null) {
                throw new NullPointerException("logger");
            }
            if (thread == null) {
                throw new NullPointerException("thread");
            }
            if (message == null) {
                throw new NullPointerException("message");
            }
            if (workflow == null) {
                throw new NullPointerException("workflow");
            }
            this.time = time;
            this.severity = severity;
            this.logger = logger;
            this.thread = thread;
            this.message = message;
            this.workflow = workflow;
        }

        @Override
        @AutoMatter.Field
        public String time() {
            return this.time;
        }

        @Override
        @AutoMatter.Field
        public String severity() {
            return this.severity;
        }

        @Override
        @AutoMatter.Field
        public String logger() {
            return this.logger;
        }

        @Override
        @AutoMatter.Field
        public String thread() {
            return this.thread;
        }

        @Override
        @AutoMatter.Field
        public String message() {
            return this.message;
        }

        @Override
        @AutoMatter.Field
        public StructuredLogMessage.Workflow workflow() {
            return this.workflow;
        }

        public StructuredLogMessageBuilder builder() {
            return new StructuredLogMessageBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructuredLogMessage)) {
                return false;
            }
            StructuredLogMessage that = (StructuredLogMessage)o;
            if (this.time != null ? !this.time.equals(that.time()) : that.time() != null) {
                return false;
            }
            if (this.severity != null ? !this.severity.equals(that.severity()) : that.severity() != null) {
                return false;
            }
            if (this.logger != null ? !this.logger.equals(that.logger()) : that.logger() != null) {
                return false;
            }
            if (this.thread != null ? !this.thread.equals(that.thread()) : that.thread() != null) {
                return false;
            }
            if (this.message != null ? !this.message.equals(that.message()) : that.message() != null) {
                return false;
            }
            return !(this.workflow != null ? !this.workflow.equals(that.workflow()) : that.workflow() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.time != null ? this.time.hashCode() : 0);
            result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
            result = 31 * result + (this.logger != null ? this.logger.hashCode() : 0);
            result = 31 * result + (this.thread != null ? this.thread.hashCode() : 0);
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StructuredLogMessage{time=" + this.time + ", severity=" + this.severity + ", logger=" + this.logger + ", thread=" + this.thread + ", message=" + this.message + ", workflow=" + this.workflow + '}';
        }
    }
}

