/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.spotify.flo.contrib.styx.StructuredLoggingEncoder;
import java.util.Locale;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class StructuredLogging {
    private static final String DEFAULT_LOGGING_LEVEL = System.getenv().getOrDefault("FLO_LOGGING_LEVEL", "INFO");

    private StructuredLogging() {
        throw new UnsupportedOperationException();
    }

    public static void configureStructuredLogging() {
        StructuredLogging.configureStructuredLogging(StructuredLogging.defaultLoggingLevel());
    }

    public static void configureStructuredLogging(org.slf4j.event.Level level) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext context = rootLogger.getLoggerContext();
        context.reset();
        StructuredLoggingEncoder encoder = new StructuredLoggingEncoder();
        encoder.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setTarget("System.err");
        appender.setName("stderr");
        appender.setEncoder((Encoder)encoder);
        appender.setContext((Context)context);
        appender.start();
        rootLogger.addAppender((Appender)appender);
        rootLogger.setLevel(Level.fromLocationAwareLoggerInteger((int)level.toInt()));
        SLF4JBridgeHandler.install();
    }

    private static org.slf4j.event.Level defaultLoggingLevel() {
        return org.slf4j.event.Level.valueOf((String)DEFAULT_LOGGING_LEVEL.toUpperCase(Locale.ROOT));
    }
}

