/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.spotify.flo.TaskId;
import com.spotify.flo.Tracing;
import com.spotify.flo.contrib.styx.StructuredLogMessage;
import com.spotify.flo.contrib.styx.StructuredLogMessageBuilder;
import com.spotify.flo.contrib.styx.StyxBuilder;
import com.spotify.flo.contrib.styx.WorkflowBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;

public class StructuredLoggingEncoder
extends EncoderBase<ILoggingEvent> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectWriter WRITER = MAPPER.writer();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final byte[] LINE_SEPARATOR_BYTES = LINE_SEPARATOR.getBytes();
    private final boolean structuredLogging = "structured".equals(System.getenv("STYX_LOGGING"));
    private final StyxBuilder template = StructuredLoggingEncoder.createTemplate();
    private final TaskId envTaskId = Optional.ofNullable(System.getenv("FLO_TASK_ID")).map(TaskId::parse).orElse(null);

    public byte[] encode(ILoggingEvent event) {
        if (this.structuredLogging) {
            return this.encodeStructured(event);
        }
        return this.encodeText(event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] encodeStructured(ILoggingEvent event) {
        StructuredLogMessageBuilder structuredLogMessageBuilder = StructuredLogMessage.newBuilder();
        structuredLogMessageBuilder.time(Instant.ofEpochMilli(event.getTimeStamp()).toString());
        structuredLogMessageBuilder.severity(event.getLevel().toString());
        structuredLogMessageBuilder.logger(event.getLoggerName());
        structuredLogMessageBuilder.thread(event.getThreadName());
        StringBuilder message = new StringBuilder(event.getFormattedMessage());
        IThrowableProxy t = event.getThrowableProxy();
        if (t != null) {
            message.append('\n');
            StructuredLoggingEncoder.writeStack(message, t, "", 0, "\n");
        }
        structuredLogMessageBuilder.message(message.toString());
        WorkflowBuilder workflowBuilder = StructuredLogMessage.Workflow.newBuilder().styx(this.template.build());
        TaskId taskId = this.taskId();
        workflowBuilder.task(StructuredLogMessage.Task.newBuilder().id(taskId != null ? taskId.toString() : "").name(taskId != null ? taskId.name() : "").args(taskId != null ? taskId.args() : "").build());
        structuredLogMessageBuilder.workflow(workflowBuilder.build());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            WRITER.writeValue((OutputStream)baos, (Object)structuredLogMessageBuilder.build());
            baos.write(LINE_SEPARATOR_BYTES);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TaskId taskId() {
        return this.envTaskId != null ? this.envTaskId : Tracing.currentTaskId();
    }

    private byte[] encodeText(ILoggingEvent event) {
        TaskId taskId = this.taskId();
        String taskIdString = taskId != null ? taskId.toString() : "";
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%s %-5s [%s] %s: %s%n", Instant.ofEpochMilli(event.getTimeStamp()).toString(), event.getLevel(), taskIdString, this.loggerName(event), event.getFormattedMessage());
        IThrowableProxy t = event.getThrowableProxy();
        if (t != null) {
            StructuredLoggingEncoder.writeStack(sb, t, "", 0, LINE_SEPARATOR);
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    private String loggerName(ILoggingEvent event) {
        String loggerName = event.getLoggerName();
        int ix = loggerName.lastIndexOf(46);
        if (ix == -1) {
            return loggerName;
        }
        return loggerName.substring(ix + 1);
    }

    private static void writeStack(StringBuilder sb, IThrowableProxy t, String caption, int indent, String linebreak) {
        if (t == null) {
            return;
        }
        StructuredLoggingEncoder.indent(sb, indent).append(caption).append(t.getClassName()).append(": ").append(t.getMessage()).append(linebreak);
        StackTraceElementProxy[] trace = t.getStackTraceElementProxyArray();
        if (trace != null) {
            IThrowableProxy[] suppressed;
            int commonFrames = t.getCommonFrames();
            int printFrames = trace.length - commonFrames;
            for (int i = 0; i < printFrames; ++i) {
                StructuredLoggingEncoder.indent(sb, indent).append("\t").append(trace[i]).append(linebreak);
            }
            if (commonFrames != 0) {
                StructuredLoggingEncoder.indent(sb, indent).append("\t... ").append(commonFrames).append(" more").append(linebreak);
            }
            for (IThrowableProxy st : suppressed = t.getSuppressed()) {
                StructuredLoggingEncoder.writeStack(sb, st, "Suppressed: ", indent + 1, linebreak);
            }
        }
        StructuredLoggingEncoder.writeStack(sb, t.getCause(), "Caused by: ", indent, linebreak);
    }

    private static StringBuilder indent(StringBuilder sb, int indent) {
        for (int j = 0; j < indent; ++j) {
            sb.append('\t');
        }
        return sb;
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] footerBytes() {
        return null;
    }

    private static StyxBuilder createTemplate() {
        Map<String, String> env = System.getenv();
        return StructuredLogMessage.Styx.newBuilder().component_id(env.getOrDefault("STYX_COMPONENT_ID", "")).workflow_id(env.getOrDefault("STYX_WORKFLOW_ID", "")).docker_args(env.getOrDefault("STYX_DOCKER_ARGS", "")).docker_image(env.getOrDefault("STYX_DOCKER_IMAGE", "")).commit_sha(env.getOrDefault("STYX_COMMIT_SHA", "")).parameter(env.getOrDefault("STYX_PARAMETER", "")).execution_id(env.getOrDefault("STYX_EXECUTION_ID", "")).trigger_id(env.getOrDefault("STYX_TRIGGER_ID", "")).trigger_type(env.getOrDefault("STYX_TRIGGER_TYPE", ""));
    }
}

