/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import com.spotify.flo.contrib.styx.StructuredLogMessage;
import io.norberg.automatter.AutoMatter;

public final class StyxBuilder {
    private String component_id;
    private String workflow_id;
    private String docker_args;
    private String docker_image;
    private String commit_sha;
    private String parameter;
    private String execution_id;
    private String trigger_id;
    private String trigger_type;

    public StyxBuilder() {
    }

    private StyxBuilder(StructuredLogMessage.Styx v) {
        this.component_id = v.component_id();
        this.workflow_id = v.workflow_id();
        this.docker_args = v.docker_args();
        this.docker_image = v.docker_image();
        this.commit_sha = v.commit_sha();
        this.parameter = v.parameter();
        this.execution_id = v.execution_id();
        this.trigger_id = v.trigger_id();
        this.trigger_type = v.trigger_type();
    }

    private StyxBuilder(StyxBuilder v) {
        this.component_id = v.component_id;
        this.workflow_id = v.workflow_id;
        this.docker_args = v.docker_args;
        this.docker_image = v.docker_image;
        this.commit_sha = v.commit_sha;
        this.parameter = v.parameter;
        this.execution_id = v.execution_id;
        this.trigger_id = v.trigger_id;
        this.trigger_type = v.trigger_type;
    }

    public String component_id() {
        return this.component_id;
    }

    public StyxBuilder component_id(String component_id) {
        if (component_id == null) {
            throw new NullPointerException("component_id");
        }
        this.component_id = component_id;
        return this;
    }

    public String workflow_id() {
        return this.workflow_id;
    }

    public StyxBuilder workflow_id(String workflow_id) {
        if (workflow_id == null) {
            throw new NullPointerException("workflow_id");
        }
        this.workflow_id = workflow_id;
        return this;
    }

    public String docker_args() {
        return this.docker_args;
    }

    public StyxBuilder docker_args(String docker_args) {
        if (docker_args == null) {
            throw new NullPointerException("docker_args");
        }
        this.docker_args = docker_args;
        return this;
    }

    public String docker_image() {
        return this.docker_image;
    }

    public StyxBuilder docker_image(String docker_image) {
        if (docker_image == null) {
            throw new NullPointerException("docker_image");
        }
        this.docker_image = docker_image;
        return this;
    }

    public String commit_sha() {
        return this.commit_sha;
    }

    public StyxBuilder commit_sha(String commit_sha) {
        if (commit_sha == null) {
            throw new NullPointerException("commit_sha");
        }
        this.commit_sha = commit_sha;
        return this;
    }

    public String parameter() {
        return this.parameter;
    }

    public StyxBuilder parameter(String parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter");
        }
        this.parameter = parameter;
        return this;
    }

    public String execution_id() {
        return this.execution_id;
    }

    public StyxBuilder execution_id(String execution_id) {
        if (execution_id == null) {
            throw new NullPointerException("execution_id");
        }
        this.execution_id = execution_id;
        return this;
    }

    public String trigger_id() {
        return this.trigger_id;
    }

    public StyxBuilder trigger_id(String trigger_id) {
        if (trigger_id == null) {
            throw new NullPointerException("trigger_id");
        }
        this.trigger_id = trigger_id;
        return this;
    }

    public String trigger_type() {
        return this.trigger_type;
    }

    public StyxBuilder trigger_type(String trigger_type) {
        if (trigger_type == null) {
            throw new NullPointerException("trigger_type");
        }
        this.trigger_type = trigger_type;
        return this;
    }

    public StructuredLogMessage.Styx build() {
        return new Value(this.component_id, this.workflow_id, this.docker_args, this.docker_image, this.commit_sha, this.parameter, this.execution_id, this.trigger_id, this.trigger_type);
    }

    public static StyxBuilder from(StructuredLogMessage.Styx v) {
        return new StyxBuilder(v);
    }

    public static StyxBuilder from(StyxBuilder v) {
        return new StyxBuilder(v);
    }

    private static final class Value
    implements StructuredLogMessage.Styx {
        private final String component_id;
        private final String workflow_id;
        private final String docker_args;
        private final String docker_image;
        private final String commit_sha;
        private final String parameter;
        private final String execution_id;
        private final String trigger_id;
        private final String trigger_type;

        private Value(@AutoMatter.Field(value="component_id") String component_id, @AutoMatter.Field(value="workflow_id") String workflow_id, @AutoMatter.Field(value="docker_args") String docker_args, @AutoMatter.Field(value="docker_image") String docker_image, @AutoMatter.Field(value="commit_sha") String commit_sha, @AutoMatter.Field(value="parameter") String parameter, @AutoMatter.Field(value="execution_id") String execution_id, @AutoMatter.Field(value="trigger_id") String trigger_id, @AutoMatter.Field(value="trigger_type") String trigger_type) {
            if (component_id == null) {
                throw new NullPointerException("component_id");
            }
            if (workflow_id == null) {
                throw new NullPointerException("workflow_id");
            }
            if (docker_args == null) {
                throw new NullPointerException("docker_args");
            }
            if (docker_image == null) {
                throw new NullPointerException("docker_image");
            }
            if (commit_sha == null) {
                throw new NullPointerException("commit_sha");
            }
            if (parameter == null) {
                throw new NullPointerException("parameter");
            }
            if (execution_id == null) {
                throw new NullPointerException("execution_id");
            }
            if (trigger_id == null) {
                throw new NullPointerException("trigger_id");
            }
            if (trigger_type == null) {
                throw new NullPointerException("trigger_type");
            }
            this.component_id = component_id;
            this.workflow_id = workflow_id;
            this.docker_args = docker_args;
            this.docker_image = docker_image;
            this.commit_sha = commit_sha;
            this.parameter = parameter;
            this.execution_id = execution_id;
            this.trigger_id = trigger_id;
            this.trigger_type = trigger_type;
        }

        @Override
        @AutoMatter.Field
        public String component_id() {
            return this.component_id;
        }

        @Override
        @AutoMatter.Field
        public String workflow_id() {
            return this.workflow_id;
        }

        @Override
        @AutoMatter.Field
        public String docker_args() {
            return this.docker_args;
        }

        @Override
        @AutoMatter.Field
        public String docker_image() {
            return this.docker_image;
        }

        @Override
        @AutoMatter.Field
        public String commit_sha() {
            return this.commit_sha;
        }

        @Override
        @AutoMatter.Field
        public String parameter() {
            return this.parameter;
        }

        @Override
        @AutoMatter.Field
        public String execution_id() {
            return this.execution_id;
        }

        @Override
        @AutoMatter.Field
        public String trigger_id() {
            return this.trigger_id;
        }

        @Override
        @AutoMatter.Field
        public String trigger_type() {
            return this.trigger_type;
        }

        public StyxBuilder builder() {
            return new StyxBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructuredLogMessage.Styx)) {
                return false;
            }
            StructuredLogMessage.Styx that = (StructuredLogMessage.Styx)o;
            if (this.component_id != null ? !this.component_id.equals(that.component_id()) : that.component_id() != null) {
                return false;
            }
            if (this.workflow_id != null ? !this.workflow_id.equals(that.workflow_id()) : that.workflow_id() != null) {
                return false;
            }
            if (this.docker_args != null ? !this.docker_args.equals(that.docker_args()) : that.docker_args() != null) {
                return false;
            }
            if (this.docker_image != null ? !this.docker_image.equals(that.docker_image()) : that.docker_image() != null) {
                return false;
            }
            if (this.commit_sha != null ? !this.commit_sha.equals(that.commit_sha()) : that.commit_sha() != null) {
                return false;
            }
            if (this.parameter != null ? !this.parameter.equals(that.parameter()) : that.parameter() != null) {
                return false;
            }
            if (this.execution_id != null ? !this.execution_id.equals(that.execution_id()) : that.execution_id() != null) {
                return false;
            }
            if (this.trigger_id != null ? !this.trigger_id.equals(that.trigger_id()) : that.trigger_id() != null) {
                return false;
            }
            return !(this.trigger_type != null ? !this.trigger_type.equals(that.trigger_type()) : that.trigger_type() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.component_id != null ? this.component_id.hashCode() : 0);
            result = 31 * result + (this.workflow_id != null ? this.workflow_id.hashCode() : 0);
            result = 31 * result + (this.docker_args != null ? this.docker_args.hashCode() : 0);
            result = 31 * result + (this.docker_image != null ? this.docker_image.hashCode() : 0);
            result = 31 * result + (this.commit_sha != null ? this.commit_sha.hashCode() : 0);
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            result = 31 * result + (this.execution_id != null ? this.execution_id.hashCode() : 0);
            result = 31 * result + (this.trigger_id != null ? this.trigger_id.hashCode() : 0);
            result = 31 * result + (this.trigger_type != null ? this.trigger_type.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StructuredLogMessage.Styx{component_id=" + this.component_id + ", workflow_id=" + this.workflow_id + ", docker_args=" + this.docker_args + ", docker_image=" + this.docker_image + ", commit_sha=" + this.commit_sha + ", parameter=" + this.parameter + ", execution_id=" + this.execution_id + ", trigger_id=" + this.trigger_id + ", trigger_type=" + this.trigger_type + '}';
        }
    }
}

