/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import com.spotify.flo.contrib.styx.StructuredLogMessage;
import io.norberg.automatter.AutoMatter;

public final class TaskBuilder {
    private String id;
    private String name;
    private String args;

    public TaskBuilder() {
    }

    private TaskBuilder(StructuredLogMessage.Task v) {
        this.id = v.id();
        this.name = v.name();
        this.args = v.args();
    }

    private TaskBuilder(TaskBuilder v) {
        this.id = v.id;
        this.name = v.name;
        this.args = v.args;
    }

    public String id() {
        return this.id;
    }

    public TaskBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public TaskBuilder name(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
        return this;
    }

    public String args() {
        return this.args;
    }

    public TaskBuilder args(String args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = args;
        return this;
    }

    public StructuredLogMessage.Task build() {
        return new Value(this.id, this.name, this.args);
    }

    public static TaskBuilder from(StructuredLogMessage.Task v) {
        return new TaskBuilder(v);
    }

    public static TaskBuilder from(TaskBuilder v) {
        return new TaskBuilder(v);
    }

    private static final class Value
    implements StructuredLogMessage.Task {
        private final String id;
        private final String name;
        private final String args;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="name") String name, @AutoMatter.Field(value="args") String args) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (args == null) {
                throw new NullPointerException("args");
            }
            this.id = id;
            this.name = name;
            this.args = args;
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public String name() {
            return this.name;
        }

        @Override
        @AutoMatter.Field
        public String args() {
            return this.args;
        }

        public TaskBuilder builder() {
            return new TaskBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructuredLogMessage.Task)) {
                return false;
            }
            StructuredLogMessage.Task that = (StructuredLogMessage.Task)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name()) : that.name() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StructuredLogMessage.Task{id=" + this.id + ", name=" + this.name + ", args=" + this.args + '}';
        }
    }
}

