/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import com.spotify.flo.context.TerminationHook;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminationLogging
implements TerminationHook {
    private static final Logger LOG = LoggerFactory.getLogger(TerminationLogging.class);

    public void accept(Integer exitCode) {
        Map<String, String> env = System.getenv();
        String terminationLog = env.get("STYX_TERMINATION_LOG");
        if (terminationLog == null) {
            return;
        }
        String content = String.format("{\"component_id\": \"%s\",\"workflow_id\": \"%s\",\"parameter\": \"%s\",\"execution_id\": \"%s\",\"event\": \"exited\",\"exit_code\": %d}", env.getOrDefault("STYX_COMPONENT_ID", "UNKNOWN_COMPONENT_ID"), env.getOrDefault("STYX_WORKFLOW_ID", "UNKNOWN_WORKFLOW_ID"), env.getOrDefault("STYX_PARAMETER", "UNKNOWN_PARAMETER"), env.getOrDefault("STYX_EXECUTION_ID", "UNKNOWN_EXECUTION_ID"), exitCode);
        Path path = Paths.get(terminationLog, new String[0]);
        try {
            Files.write(path, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOG.error("Could not write termination log to {}.", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

