/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.contrib.styx;

import com.spotify.flo.contrib.styx.StructuredLogMessage;
import io.norberg.automatter.AutoMatter;

public final class WorkflowBuilder {
    private StructuredLogMessage.Styx styx;
    private String framework;
    private StructuredLogMessage.Task task;

    public WorkflowBuilder() {
    }

    private WorkflowBuilder(StructuredLogMessage.Workflow v) {
        this.styx = v.styx();
        this.framework = v.framework();
        this.task = v.task();
    }

    private WorkflowBuilder(WorkflowBuilder v) {
        this.styx = v.styx;
        this.framework = v.framework;
        this.task = v.task;
    }

    public StructuredLogMessage.Styx styx() {
        return this.styx;
    }

    public WorkflowBuilder styx(StructuredLogMessage.Styx styx) {
        if (styx == null) {
            throw new NullPointerException("styx");
        }
        this.styx = styx;
        return this;
    }

    public String framework() {
        return this.framework;
    }

    public WorkflowBuilder framework(String framework) {
        if (framework == null) {
            throw new NullPointerException("framework");
        }
        this.framework = framework;
        return this;
    }

    public StructuredLogMessage.Task task() {
        return this.task;
    }

    public WorkflowBuilder task(StructuredLogMessage.Task task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        this.task = task;
        return this;
    }

    public StructuredLogMessage.Workflow build() {
        return new Value(this.styx, this.framework, this.task);
    }

    public static WorkflowBuilder from(StructuredLogMessage.Workflow v) {
        return new WorkflowBuilder(v);
    }

    public static WorkflowBuilder from(WorkflowBuilder v) {
        return new WorkflowBuilder(v);
    }

    private static final class Value
    implements StructuredLogMessage.Workflow {
        private final StructuredLogMessage.Styx styx;
        private final String framework;
        private final StructuredLogMessage.Task task;

        private Value(@AutoMatter.Field(value="styx") StructuredLogMessage.Styx styx, @AutoMatter.Field(value="framework") String framework, @AutoMatter.Field(value="task") StructuredLogMessage.Task task) {
            if (styx == null) {
                throw new NullPointerException("styx");
            }
            if (framework == null) {
                throw new NullPointerException("framework");
            }
            if (task == null) {
                throw new NullPointerException("task");
            }
            this.styx = styx;
            this.framework = framework;
            this.task = task;
        }

        @Override
        @AutoMatter.Field
        public StructuredLogMessage.Styx styx() {
            return this.styx;
        }

        @Override
        @AutoMatter.Field
        public String framework() {
            return this.framework;
        }

        @Override
        @AutoMatter.Field
        public StructuredLogMessage.Task task() {
            return this.task;
        }

        public WorkflowBuilder builder() {
            return new WorkflowBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StructuredLogMessage.Workflow)) {
                return false;
            }
            StructuredLogMessage.Workflow that = (StructuredLogMessage.Workflow)o;
            if (this.styx != null ? !this.styx.equals(that.styx()) : that.styx() != null) {
                return false;
            }
            if (this.framework != null ? !this.framework.equals(that.framework()) : that.framework() != null) {
                return false;
            }
            return !(this.task != null ? !this.task.equals(that.task()) : that.task() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.styx != null ? this.styx.hashCode() : 0);
            result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
            result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "StructuredLogMessage.Workflow{styx=" + this.styx + ", framework=" + this.framework + ", task=" + this.task + '}';
        }
    }
}

