/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.EvalClosure;
import com.spotify.flo.Fn;
import com.spotify.flo.Fn1;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContext;
import com.spotify.flo.TaskId;
import com.spotify.flo.Values;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BuilderUtils {
    private BuilderUtils() {
    }

    static <F, Z> ChainingEval<F, Z> leafEvalFn(EvalClosure<Fn1<F, TaskContext.Value<Z>>> fClosure) {
        return new ChainingEval<F, Z>(fClosure);
    }

    static <R> EvalClosure<R> gated(TaskId taskId, Fn<R> code) {
        return tc -> tc.invokeProcessFn(taskId, () -> tc.value(code));
    }

    static <R> EvalClosure<R> gatedVal(TaskId taskId, Fn1<TaskContext, TaskContext.Value<R>> code) {
        return tc -> tc.invokeProcessFn(taskId, () -> (TaskContext.Value)code.apply(tc));
    }

    @SafeVarargs
    static Fn<List<Task<?>>> lazyList(Fn<? extends Task<?>> ... tasks) {
        return () -> Stream.of(tasks).map(Supplier::get).collect(Collectors.toList());
    }

    @SafeVarargs
    static <T> Fn<List<T>> lazyFlatten(Fn<? extends List<? extends T>> ... lists) {
        return () -> Stream.of(lists).map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static <T> List<T> appendToList(List<T> list, T t) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.add(t);
        return newList;
    }

    static final class ChainingEval<F, Z>
    implements Serializable {
        private final EvalClosure<Fn1<F, TaskContext.Value<Z>>> fClosure;

        ChainingEval(EvalClosure<Fn1<F, TaskContext.Value<Z>>> fClosure) {
            this.fClosure = fClosure;
        }

        EvalClosure<Z> enclose(F f) {
            return taskContext -> this.fClosure.eval(taskContext).flatMap(ff -> (TaskContext.Value)ff.apply(f));
        }

        <G> ChainingEval<G, Z> chain(EvalClosure<Fn1<G, F>> mapClosure) {
            EvalClosure<Fn1<F, TaskContext.Value<Z>>> continuation = tc -> {
                TaskContext.Value gv = mapClosure.eval(tc);
                TaskContext.Value<Fn1<F, TaskContext.Value<Z>>> fv = this.fClosure.eval(tc);
                return Values.mapBoth(tc, gv, fv, (gc, fc) -> g -> (TaskContext.Value)fc.apply(gc.apply(g)));
            };
            return new ChainingEval<F, Z>(continuation);
        }
    }
}

