/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.AutoValue_Task;
import com.spotify.flo.EvalClosure;
import com.spotify.flo.Fn;
import com.spotify.flo.NamedTaskBuilder;
import com.spotify.flo.OpProvider;
import com.spotify.flo.TaskBuilder;
import com.spotify.flo.TaskBuilderImpl;
import com.spotify.flo.TaskContext;
import com.spotify.flo.TaskId;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public abstract class Task<T>
implements Serializable {
    public abstract TaskId id();

    public abstract Class<T> type();

    abstract EvalClosure<T> code();

    abstract Fn<List<Task<?>>> lazyInputs();

    public abstract List<OpProvider<?>> ops();

    public List<Task<?>> inputs() {
        return (List)this.lazyInputs().get();
    }

    public Stream<Task<?>> inputsInOrder() {
        return this.inputsInOrder(new HashSet<TaskId>());
    }

    private Stream<Task<?>> inputsInOrder(Set<TaskId> visits) {
        return this.inputs().stream().filter(input -> !visits.contains(input.id())).peek(input -> visits.add(input.id())).flatMap(input -> Stream.concat(input.inputsInOrder(visits), Stream.of(input)));
    }

    public static NamedTaskBuilder named(String taskName, Object ... args) {
        return new NTB(TaskId.create(taskName, args));
    }

    public static <T> Task<T> create(Fn<T> code, Class<T> type, String taskName, Object ... args) {
        return Task.create(Collections::emptyList, Collections.emptyList(), type, (TaskContext tc) -> tc.value(code), TaskId.create(taskName, args));
    }

    static <T> Task<T> create(Fn<List<Task<?>>> inputs, List<OpProvider<?>> ops, Class<T> type, EvalClosure<T> code, TaskId taskId) {
        return new AutoValue_Task<T>(taskId, type, code, inputs, ops);
    }

    private static final class NTB
    implements NamedTaskBuilder {
        private final TaskId taskId;

        private NTB(TaskId taskId) {
            this.taskId = taskId;
        }

        @Override
        public <Z> TaskBuilder<Z> ofType(Class<Z> type) {
            return TaskBuilderImpl.rootBuilder(this.taskId, type);
        }
    }
}

