/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContextWithTask;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.AsyncContext;
import com.spotify.flo.context.InMemImmediateContext;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TaskContext {
    public static final Logger LOG = LoggerFactory.getLogger(TaskContext.class);

    default public <T> Value<T> evaluate(Task<T> task) {
        return this.evaluateInternal(task, TaskContextWithTask.withTask(this, task));
    }

    default public <T> Value<T> evaluateInternal(Task<T> task, TaskContext context) {
        return task.code().eval(context);
    }

    default public <T> Value<T> invokeProcessFn(TaskId taskId, Fn<Value<T>> processFn) {
        return (Value)processFn.get();
    }

    default public Optional<Task<?>> currentTask() {
        return Optional.empty();
    }

    public <T> Value<T> value(Fn<T> var1);

    default public <T> Value<T> immediateValue(T value) {
        return this.value(() -> value);
    }

    public <T> Promise<T> promise();

    public static TaskContext inmem() {
        return InMemImmediateContext.create();
    }

    public static TaskContext async(Executor executor) {
        return AsyncContext.create(executor);
    }

    public static interface Promise<T> {
        public Value<T> value();

        public void set(T var1);

        public void fail(Throwable var1);
    }

    public static interface Value<T> {
        public TaskContext context();

        public void consume(Consumer<T> var1);

        public void onFail(Consumer<Throwable> var1);

        default public <U> Value<U> map(Function<? super T, ? extends U> fn) {
            return this.flatMap(fn.andThen(this.context()::immediateValue));
        }

        public <U> Value<U> flatMap(Function<? super T, ? extends Value<? extends U>> var1);
    }
}

