/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.AutoValue_TaskIds;
import com.spotify.flo.TaskId;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class TaskIds
implements TaskId,
Serializable {
    TaskIds() {
    }

    abstract String args();

    static TaskId create(String name, Object ... args) {
        if (name.contains("(") || name.contains(")")) {
            throw new IllegalArgumentException("Name can not contain any parenthesis");
        }
        return new AutoValue_TaskIds(name, name.hashCode() * 1000003 ^ Objects.hash(args), TaskIds.argsString(args));
    }

    static TaskId parse(String stringId) {
        int pOpen = stringId.indexOf(40);
        int pClose = stringId.lastIndexOf(41);
        int pHash = stringId.lastIndexOf(35);
        if (pOpen < 0 || pClose < pOpen || pHash < pClose) {
            throw new IllegalArgumentException("Invalid stringId, follow 'Name(foo,bar)#deadbeef'");
        }
        String name = stringId.substring(0, pOpen);
        if (name.contains(")")) {
            throw new IllegalArgumentException("Name can not contain any parenthesis");
        }
        String args = stringId.substring(pOpen + 1, pClose);
        String hash = stringId.substring(pHash + 1);
        return new AutoValue_TaskIds(name, Integer.parseUnsignedInt(hash, 16), args);
    }

    public String toString() {
        return String.format("%s(%s)#%08x", this.name(), this.args(), this.hash());
    }

    private static String argsString(Object ... args) {
        return Stream.of(args).map(Object::toString).collect(Collectors.joining(","));
    }
}

