/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.AutoValue_TaskInfo;
import com.spotify.flo.Task;
import com.spotify.flo.TaskId;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class TaskInfo {
    public abstract TaskId id();

    public abstract boolean isReference();

    public abstract List<TaskInfo> inputs();

    public static TaskInfo ref(TaskId id) {
        return new AutoValue_TaskInfo(id, true, Collections.emptyList());
    }

    public static TaskInfo create(TaskId id, List<TaskInfo> upstreams) {
        return new AutoValue_TaskInfo(id, false, upstreams);
    }

    public static TaskInfo ofTask(Task<?> task) {
        return TaskInfo.ofTask(task, new HashSet<TaskId>());
    }

    public static TaskInfo ofTask(Task<?> task, Set<TaskId> visits) {
        TaskId id = task.id();
        if (visits.contains(id)) {
            return TaskInfo.ref(id);
        }
        visits.add(id);
        List<TaskInfo> upstreams = task.inputs().stream().map(t -> TaskInfo.ofTask(t, visits)).collect(Collectors.toList());
        return TaskInfo.create(id, upstreams);
    }
}

