/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.TaskContext;
import com.spotify.flo.Values;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class ValueFold<T>
implements Function<List<TaskContext.Value<T>>, TaskContext.Value<List<T>>> {
    private final TaskContext taskContext;

    ValueFold(TaskContext taskContext) {
        this.taskContext = Objects.requireNonNull(taskContext);
    }

    static <T> ValueFold<T> inContext(TaskContext taskContext) {
        return new ValueFold<T>(taskContext);
    }

    @Override
    public TaskContext.Value<List<T>> apply(List<TaskContext.Value<T>> list) {
        TaskContext.Value<List<T>> values = this.taskContext.immediateValue(new ArrayList());
        for (TaskContext.Value<T> tValue : list) {
            values = Values.mapBoth(this.taskContext, values, tValue, (l, t) -> {
                l.add(t);
                return l;
            });
        }
        return values;
    }
}

