/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo;

import com.spotify.flo.TaskContext;
import com.spotify.flo.ValueFold;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collector;

public final class Values {
    private Values() {
    }

    public static <T, U, V> TaskContext.Value<V> mapBoth(TaskContext context, TaskContext.Value<T> first, TaskContext.Value<U> second, BiFunction<? super T, ? super U, ? extends V> fn) {
        TaskContext.Promise promise = context.promise();
        BiConsumer<Object, Throwable> firstComplete = (t, firstThrowable) -> {
            BiConsumer<Object, Throwable> secondComplete = (v, secondThrowable) -> {
                if (firstThrowable != null) {
                    promise.fail((Throwable)firstThrowable);
                } else if (secondThrowable != null) {
                    promise.fail((Throwable)secondThrowable);
                } else {
                    promise.set(fn.apply(t, v));
                }
            };
            second.consume(v -> secondComplete.accept(v, null));
            second.onFail(e -> secondComplete.accept(null, (Throwable)e));
        };
        first.consume(t -> firstComplete.accept(t, null));
        first.onFail(e -> firstComplete.accept(null, (Throwable)e));
        return promise.value();
    }

    public static <T> Collector<TaskContext.Value<T>, ?, TaskContext.Value<List<T>>> toValueList(TaskContext context) {
        return Collector.of(ArrayList::new, List::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, ValueFold.inContext(context), new Collector.Characteristics[0]);
    }
}

