/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskBuilder;
import com.spotify.flo.TaskContext;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncContext
implements TaskContext {
    private final Executor executor;

    protected AsyncContext(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public static TaskContext create(Executor executor) {
        return new AsyncContext(executor);
    }

    @Override
    public <T> TaskContext.Value<T> evaluateInternal(Task<T> task, TaskContext context) {
        return this.flatten(() -> TaskContext.super.evaluateInternal(task, context));
    }

    @Override
    public final <T> TaskContext.Value<T> value(Fn<T> t) {
        return new FutureValue(CompletableFuture.supplyAsync(t, this.executor));
    }

    @Override
    public final <T> TaskContext.Value<T> immediateValue(T t) {
        return new FutureValue(CompletableFuture.completedFuture(t));
    }

    @Override
    public <T> TaskContext.Promise<T> promise() {
        return new FuturePromise();
    }

    protected final <T> TaskContext.Value<T> flatten(TaskBuilder.F0<TaskContext.Value<T>> t) {
        return this.flatten(CompletableFuture.supplyAsync(t, this.executor));
    }

    protected final <T> TaskContext.Value<T> flatten(CompletionStage<? extends TaskContext.Value<? extends T>> future) {
        CompletableFuture next = new CompletableFuture();
        future.whenCompleteAsync((value, throwable) -> {
            if (throwable != null) {
                next.completeExceptionally(AsyncContext.resolveAppThrowable(throwable));
            } else {
                value.consume(next::complete);
                value.onFail(next::completeExceptionally);
            }
        }, this.executor);
        return new FutureValue(next);
    }

    private static Throwable resolveAppThrowable(Throwable throwable) {
        return throwable instanceof CompletionException ? AsyncContext.resolveAppThrowable(throwable.getCause()) : throwable;
    }

    private final class FuturePromise<T>
    implements TaskContext.Promise<T> {
        private final CompletableFuture<T> future = new CompletableFuture();
        private final FutureValue<T> value = new FutureValue(this.future);

        private FuturePromise() {
        }

        @Override
        public TaskContext.Value<T> value() {
            return this.value;
        }

        @Override
        public void set(T t) {
            boolean completed = this.future.complete(t);
            if (!completed) {
                throw new IllegalStateException("Promise was already completed");
            }
        }

        @Override
        public void fail(Throwable throwable) {
            boolean completed = this.future.completeExceptionally(throwable);
            if (!completed) {
                throw new IllegalStateException("Promise was already completed");
            }
        }
    }

    private final class FutureValue<T>
    implements TaskContext.Value<T> {
        private final CompletionStage<T> future;

        private FutureValue(CompletionStage<T> future) {
            this.future = future;
        }

        @Override
        public TaskContext context() {
            return AsyncContext.this;
        }

        @Override
        public void consume(Consumer<T> consumer) {
            this.future.thenAcceptAsync(consumer, AsyncContext.this.executor);
        }

        @Override
        public void onFail(Consumer<Throwable> errorConsumer) {
            this.future.whenCompleteAsync((\u02cd, throwable) -> {
                if (throwable != null) {
                    errorConsumer.accept(AsyncContext.resolveAppThrowable(throwable));
                }
            }, AsyncContext.this.executor);
        }

        @Override
        public <U> TaskContext.Value<U> map(Function<? super T, ? extends U> fn) {
            return new FutureValue<U>(this.future.thenApplyAsync(fn, AsyncContext.this.executor));
        }

        @Override
        public <U> TaskContext.Value<U> flatMap(Function<? super T, ? extends TaskContext.Value<? extends U>> function) {
            return AsyncContext.this.flatten(this.future.thenApplyAsync(function, AsyncContext.this.executor));
        }
    }
}

