/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class AwaitingConsumer<T>
implements Consumer<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private T value;

    public static <T> AwaitingConsumer<T> create() {
        return new AwaitingConsumer<T>();
    }

    @Override
    public void accept(T t) {
        this.value = t;
        this.latch.countDown();
    }

    public T get() {
        if (!this.isAvailable()) {
            throw new IllegalStateException("Value not available");
        }
        return this.value;
    }

    public boolean isAvailable() {
        return this.latch.getCount() == 0L;
    }

    public boolean await() throws InterruptedException {
        return this.await(1L, TimeUnit.SECONDS);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.latch.await(time, unit);
    }

    public T awaitAndGet() throws InterruptedException {
        if (!this.await()) {
            throw new IllegalStateException("Value did not arrive");
        }
        return this.value;
    }
}

