/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class InMemImmediateContext
implements TaskContext {
    private InMemImmediateContext() {
    }

    public static TaskContext create() {
        return new InMemImmediateContext();
    }

    @Override
    public <T> TaskContext.Value<T> evaluateInternal(Task<T> task, TaskContext context) {
        return TaskContext.super.evaluateInternal(task, context);
    }

    @Override
    public <T> TaskContext.Value<T> value(Fn<T> value) {
        TaskContext.Promise promise = this.promise();
        try {
            promise.set(value.get());
        }
        catch (Throwable t) {
            promise.fail(t);
        }
        return promise.value();
    }

    @Override
    public <T> TaskContext.Promise<T> promise() {
        return new ValuePromise();
    }

    private final class ValuePromise<T>
    implements TaskContext.Promise<T> {
        private final DirectValue<T> value;

        private ValuePromise() {
            this.value = new DirectValue();
        }

        @Override
        public TaskContext.Value<T> value() {
            return this.value;
        }

        @Override
        public void set(T t) {
            boolean completed = ((DirectValue)this.value).setLatch.tryAcquire();
            if (!completed) {
                throw new IllegalStateException("Promise was already completed");
            }
            ((DirectValue)this.value).valueReceiver.set(c -> c.accept(t));
            ((DirectValue)this.value).valueConsumers.forEach(c -> c.accept(t));
        }

        @Override
        public void fail(Throwable throwable) {
            boolean completed = ((DirectValue)this.value).setLatch.tryAcquire();
            if (!completed) {
                throw new IllegalStateException("Promise was already completed");
            }
            ((DirectValue)this.value).failureReceiver.set(c -> c.accept(throwable));
            ((DirectValue)this.value).failureConsumers.forEach(c -> c.accept(throwable));
        }
    }

    private final class DirectValue<T>
    implements TaskContext.Value<T> {
        private final Semaphore setLatch;
        private final List<Consumer<T>> valueConsumers = new ArrayList<Consumer<T>>();
        private final List<Consumer<Throwable>> failureConsumers = new ArrayList<Consumer<Throwable>>();
        private final AtomicReference<Consumer<Consumer<T>>> valueReceiver = new AtomicReference<Consumer<Consumer>>(this.valueConsumers::add);
        private final AtomicReference<Consumer<Consumer<Throwable>>> failureReceiver = new AtomicReference<Consumer<Consumer>>(this.failureConsumers::add);

        private DirectValue() {
            this.setLatch = new Semaphore(1);
        }

        @Override
        public TaskContext context() {
            return InMemImmediateContext.this;
        }

        @Override
        public <U> TaskContext.Value<U> flatMap(Function<? super T, ? extends TaskContext.Value<? extends U>> fn) {
            TaskContext.Promise promise = InMemImmediateContext.this.promise();
            this.consume(t -> {
                TaskContext.Value apply = (TaskContext.Value)fn.apply(t);
                apply.consume(promise::set);
                apply.onFail(promise::fail);
            });
            this.onFail(promise::fail);
            return promise.value();
        }

        @Override
        public void consume(Consumer<T> consumer) {
            this.valueReceiver.get().accept(consumer);
        }

        @Override
        public void onFail(Consumer<Throwable> errorConsumer) {
            this.failureReceiver.get().accept(errorConsumer);
        }
    }
}

