/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContext;
import com.spotify.flo.TaskId;
import com.spotify.flo.context.ForwardingTaskContext;
import java.util.Objects;

public class InstrumentedContext
extends ForwardingTaskContext {
    private final Listener listener;

    private InstrumentedContext(TaskContext baseContext, Listener listener) {
        super(baseContext);
        this.listener = Objects.requireNonNull(listener);
    }

    public static TaskContext composeWith(TaskContext baseContext, Listener listener) {
        return new InstrumentedContext(baseContext, listener);
    }

    @Override
    public <T> TaskContext.Value<T> evaluateInternal(Task<T> task, TaskContext context) {
        this.listener.task(task);
        return this.delegate.evaluateInternal(task, context);
    }

    @Override
    public <T> TaskContext.Value<T> invokeProcessFn(TaskId taskId, Fn<TaskContext.Value<T>> processFn) {
        this.listener.status(taskId, Listener.Phase.START);
        TaskContext.Value<Object> tValue = this.delegate.invokeProcessFn(taskId, processFn);
        tValue.consume(v -> this.listener.status(taskId, Listener.Phase.SUCCESS));
        tValue.onFail(t -> this.listener.status(taskId, Listener.Phase.FAILURE));
        return tValue;
    }

    public static interface Listener {
        public void task(Task<?> var1);

        public void status(TaskId var1, Phase var2);

        public static enum Phase {
            START,
            SUCCESS,
            FAILURE;

        }
    }
}

