/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.flo.context;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.flo.Fn;
import com.spotify.flo.Task;
import com.spotify.flo.TaskContext;
import com.spotify.flo.TaskId;
import com.spotify.flo.Util;
import com.spotify.flo.context.ForwardingTaskContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoizingContext
extends ForwardingTaskContext {
    private static final Logger LOG = LoggerFactory.getLogger(MemoizingContext.class);
    private static final Memoizer<Object> NOOP = new Memoizer<Object>(){

        @Override
        public Optional<Object> lookup(Task<Object> task) {
            return Optional.empty();
        }

        @Override
        public void store(Task<Object> task, Object value) {
        }
    };
    private final ImmutableMap<Class<?>, Memoizer<?>> memoizers;
    private final ConcurrentMap<TaskId, EvalBundle<?>> ongoing = Maps.newConcurrentMap();

    private MemoizingContext(TaskContext baseContext, ImmutableMap<Class<?>, Memoizer<?>> memoizers) {
        super(baseContext);
        this.memoizers = Objects.requireNonNull(memoizers);
    }

    public static TaskContext composeWith(TaskContext baseContext) {
        return MemoizingContext.builder(baseContext).build();
    }

    public static Builder builder(TaskContext baseContext) {
        return new Builder(baseContext);
    }

    @Override
    public <T> TaskContext.Value<T> evaluateInternal(Task<T> task, TaskContext context) {
        EvalBundle<T> bundle = this.ongoing.computeIfAbsent(task.id(), this.createBundle(task, context));
        bundle.evaluate();
        return ((EvalBundle)bundle).promise.value();
    }

    private <T> Function<TaskId, EvalBundle<T>> createBundle(Task<T> task, TaskContext context) {
        return \u02cd -> {
            Memoizer memoizer = this.findMemoizer(task.type()).orElse(Memoizer.noop());
            return new EvalBundle(task, context, memoizer);
        };
    }

    @Override
    public <T> TaskContext.Value<T> invokeProcessFn(TaskId taskId, Fn<TaskContext.Value<T>> processFn) {
        EvalBundle<T> evalBundle = this.lookupBundle(taskId);
        Task task = ((EvalBundle)evalBundle).task;
        Memoizer memoizer = ((EvalBundle)evalBundle).memoizer;
        TaskContext.Value<Object> tValue = this.delegate.invokeProcessFn(taskId, processFn);
        tValue.consume(v -> memoizer.store(task, v));
        return tValue;
    }

    private <T> EvalBundle<T> lookupBundle(TaskId taskId) {
        EvalBundle spin;
        while ((spin = (EvalBundle)this.ongoing.get(taskId)) == null) {
        }
        return spin;
    }

    private <T> Optional<Memoizer<T>> findMemoizer(Class<T> type) {
        Optional<Memoizer> tMemoizer = Optional.ofNullable((Memoizer)this.memoizers.get(type));
        return Optional.ofNullable(tMemoizer.orElseGet(() -> {
            for (Method method : type.getDeclaredMethods()) {
                if (method.getDeclaredAnnotation(Memoizer.Impl.class) == null) continue;
                return (Memoizer)MemoizingContext.invokeAndPropagateException(method, new Object[0]);
            }
            return null;
        }));
    }

    private static Object invokeAndPropagateException(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> void chain(TaskContext.Value<T> value, TaskContext.Promise<T> promise) {
        value.consume(promise::set);
        value.onFail(promise::fail);
    }

    private final class EvalBundle<T> {
        private final Task<T> task;
        private final TaskContext.Promise<T> promise;
        private final TaskContext context;
        private final Memoizer<T> memoizer;
        private volatile boolean evaluated = false;

        private EvalBundle(Task<T> task, TaskContext context, Memoizer<T> memoizer) {
            this.task = task;
            this.context = context;
            this.memoizer = memoizer;
            this.promise = context.promise();
        }

        synchronized void evaluate() {
            if (this.evaluated) {
                return;
            }
            this.evaluated = true;
            Optional<T> lookup = this.memoizer.lookup(this.task);
            if (lookup.isPresent()) {
                T t = lookup.get();
                LOG.debug("Not expanding {}, lookup = {}", (Object)Util.colored(this.task.id()), t);
                this.promise.set(t);
            } else {
                LOG.debug("Expanding {}", (Object)Util.colored(this.task.id()));
                MemoizingContext.chain(MemoizingContext.this.delegate.evaluateInternal(this.task, this.context), this.promise);
            }
        }
    }

    public static class Builder {
        private final TaskContext baseContext;
        private final ImmutableMap.Builder<Class<?>, Memoizer<?>> memoizers = ImmutableMap.builder();

        public Builder(TaskContext baseContext) {
            this.baseContext = Objects.requireNonNull(baseContext);
        }

        public <T> Builder memoizer(Memoizer<T> memoizer) {
            this.mapMemoizer(memoizer);
            return this;
        }

        public TaskContext build() {
            return new MemoizingContext(this.baseContext, this.memoizers.build());
        }

        private void mapMemoizer(Memoizer<?> memoizer) {
            for (Type iface : memoizer.getClass().getGenericInterfaces()) {
                if (!iface.getTypeName().contains(Memoizer.class.getTypeName())) continue;
                ParameterizedType paramType = (ParameterizedType)iface;
                Class memoizedType = (Class)paramType.getActualTypeArguments()[0];
                this.memoizers.put((Object)memoizedType, memoizer);
            }
        }
    }

    public static interface Memoizer<T> {
        public Optional<T> lookup(Task<T> var1);

        public void store(Task<T> var1, T var2);

        public static <T> Memoizer<T> noop() {
            return NOOP;
        }

        @Target(value={ElementType.METHOD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Impl {
        }
    }
}

