/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.annotations.VisibleForTesting;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.client.Utils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class MicrometerMetrics
implements Metrics {
    private final Timer getHits;
    private final Timer getMisses;
    private final Timer getFailures;
    private final Timer multigetCalls;
    private final Counter multigetHits;
    private final Counter multigetMisses;
    private final Timer multigetFailures;
    private final Timer setSuccesses;
    private final Timer setFailures;
    private final Timer deleteSuccesses;
    private final Timer deleteFailures;
    private final Timer incrDecrSuccesses;
    private final Timer incrDecrFailures;
    private final Timer touchSuccesses;
    private final Timer touchFailures;
    private final Set<Metrics.OutstandingRequestsGauge> gauges = new CopyOnWriteArraySet<Metrics.OutstandingRequestsGauge>();

    public MicrometerMetrics(MeterRegistry registry) {
        this(registry, Tags.empty());
    }

    public MicrometerMetrics(MeterRegistry registry, String ... tags) {
        this(registry, Tags.of((String[])tags));
    }

    public MicrometerMetrics(MeterRegistry registry, Tags tags) {
        String meterName = "memcache.requests";
        this.getHits = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "get", "result", "hits"}));
        this.getMisses = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "get", "result", "misses"}));
        this.getFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "get", "result", "failures"}));
        this.multigetCalls = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "multiget", "result", "hitsOrMisses"}));
        this.multigetHits = registry.counter(meterName, (Iterable)tags.and(new String[]{"operation", "multiget", "result", "hits"}));
        this.multigetMisses = registry.counter(meterName, (Iterable)tags.and(new String[]{"operation", "multiget", "result", "misses"}));
        this.multigetFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "multiget", "result", "failures"}));
        this.setSuccesses = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "set", "result", "successes"}));
        this.setFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "set", "result", "failures"}));
        this.deleteSuccesses = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "delete", "result", "successes"}));
        this.deleteFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "delete", "result", "failures"}));
        this.incrDecrSuccesses = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "incrdecr", "result", "successes"}));
        this.incrDecrFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "incrdecr", "result", "failures"}));
        this.touchSuccesses = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "touch", "result", "successes"}));
        this.touchFailures = registry.timer(meterName, (Iterable)tags.and(new String[]{"operation", "touch", "result", "failures"}));
        registry.gauge("memcache.outstandingRequests", (Iterable)tags, (Object)this, MicrometerMetrics::getOutstandingRequests);
        registry.gauge("memcache.global.connections", (Iterable)tags, (Object)this, o -> Utils.getGlobalConnectionCount());
    }

    @VisibleForTesting
    long getOutstandingRequests() {
        return this.gauges.stream().mapToLong(Metrics.OutstandingRequestsGauge::getOutstandingRequests).sum();
    }

    public void measureGetFuture(CompletionStage<GetResult<byte[]>> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                if (result != null) {
                    this.getHits.record(duration, TimeUnit.NANOSECONDS);
                } else {
                    this.getMisses.record(duration, TimeUnit.NANOSECONDS);
                }
            } else {
                this.getFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void measureMultigetFuture(CompletionStage<List<GetResult<byte[]>>> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                this.multigetCalls.record(duration, TimeUnit.NANOSECONDS);
                int hits = 0;
                int total = result.size();
                for (GetResult getResult : result) {
                    if (getResult == null) continue;
                    ++hits;
                }
                this.multigetHits.increment((double)hits);
                this.multigetMisses.increment((double)(total - hits));
            } else {
                this.multigetFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void measureDeleteFuture(CompletionStage<MemcacheStatus> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                this.deleteSuccesses.record(duration, TimeUnit.NANOSECONDS);
            } else {
                this.deleteFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void measureSetFuture(CompletionStage<MemcacheStatus> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                this.setSuccesses.record(duration, TimeUnit.NANOSECONDS);
            } else {
                this.setFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void measureIncrDecrFuture(CompletionStage<Long> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                this.incrDecrSuccesses.record(duration, TimeUnit.NANOSECONDS);
            } else {
                this.incrDecrFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void measureTouchFuture(CompletionStage<MemcacheStatus> future) {
        long startNs = System.nanoTime();
        future.whenComplete((result, t) -> {
            long duration = System.nanoTime() - startNs;
            if (t == null) {
                this.touchSuccesses.record(duration, TimeUnit.NANOSECONDS);
            } else {
                this.touchFailures.record(duration, TimeUnit.NANOSECONDS);
            }
        });
    }

    public void registerOutstandingRequestsGauge(Metrics.OutstandingRequestsGauge gauge) {
        this.gauges.add(gauge);
    }

    public void unregisterOutstandingRequestsGauge(Metrics.OutstandingRequestsGauge gauge) {
        this.gauges.remove(gauge);
    }
}

