package com.spotify.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Links}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinks.builder()}.
 */
@Generated(from = "Links", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinks implements Links {
  private final @Nullable Links.Href<URI> self;
  private final @Nullable Links.Href<URI> html;

  private ImmutableLinks(
      @Nullable Links.Href<URI> self,
      @Nullable Links.Href<URI> html) {
    this.self = self;
    this.html = html;
  }

  /**
   * Link to this entity in the API.
   * @return The link to the API of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> self() {
    return self;
  }

  /**
   * Link to the HTML representaion of this item.
   * @return The link to the HTML representation of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> html() {
    return html;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Links#self() self} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for self (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinks withSelf(@Nullable Links.Href<URI> value) {
    if (this.self == value) return this;
    return new ImmutableLinks(value, this.html);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Links#html() html} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for html (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinks withHtml(@Nullable Links.Href<URI> value) {
    if (this.html == value) return this;
    return new ImmutableLinks(this.self, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinks
        && equalTo((ImmutableLinks) another);
  }

  private boolean equalTo(ImmutableLinks another) {
    return Objects.equals(self, another.self)
        && Objects.equals(html, another.html);
  }

  /**
   * Computes a hash code from attributes: {@code self}, {@code html}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(self);
    h += (h << 5) + Objects.hashCode(html);
    return h;
  }

  /**
   * Prints the immutable value {@code Links} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Links{"
        + "self=" + self
        + ", html=" + html
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Links", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Links {
    @Nullable Links.Href<URI> self;
    @Nullable Links.Href<URI> html;
    @JsonProperty
    public void setSelf(@Nullable Links.Href<URI> self) {
      this.self = self;
    }
    @JsonProperty
    public void setHtml(@Nullable Links.Href<URI> html) {
      this.html = html;
    }
    @Override
    public Links.Href<URI> self() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> html() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLinks fromJson(Json json) {
    ImmutableLinks.Builder builder = ImmutableLinks.builder();
    if (json.self != null) {
      builder.self(json.self);
    }
    if (json.html != null) {
      builder.html(json.html);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Links} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Links instance
   */
  public static ImmutableLinks copyOf(Links instance) {
    if (instance instanceof ImmutableLinks) {
      return (ImmutableLinks) instance;
    }
    return ImmutableLinks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinks ImmutableLinks}.
   * <pre>
   * ImmutableLinks.builder()
   *    .self(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link Links#self() self}
   *    .html(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link Links#html() html}
   *    .build();
   * </pre>
   * @return A new ImmutableLinks builder
   */
  public static ImmutableLinks.Builder builder() {
    return new ImmutableLinks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinks ImmutableLinks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Links", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Links.Href<URI> self;
    private @Nullable Links.Href<URI> html;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Links} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Links instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Links.Href<URI> selfValue = instance.self();
      if (selfValue != null) {
        self(selfValue);
      }
      @Nullable Links.Href<URI> htmlValue = instance.html();
      if (htmlValue != null) {
        html(htmlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Links#self() self} attribute.
     * @param self The value for self (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder self(@Nullable Links.Href<URI> self) {
      this.self = self;
      return this;
    }

    /**
     * Initializes the value for the {@link Links#html() html} attribute.
     * @param html The value for html (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder html(@Nullable Links.Href<URI> html) {
      this.html = html;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinks ImmutableLinks}.
     * @return An immutable instance of Links
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinks build() {
      return new ImmutableLinks(self, html);
    }
  }
}
