package com.spotify.github.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Link}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLink.builder()}.
 */
@Generated(from = "Link", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLink implements Link {
  private final URI url;
  private final @Nullable String rel;
  private final @Nullable String rev;
  private final @Nullable String type;
  private final @Nullable String media;
  private final @Nullable String title;
  private final @Nullable String anchor;

  private ImmutableLink(
      URI url,
      @Nullable String rel,
      @Nullable String rev,
      @Nullable String type,
      @Nullable String media,
      @Nullable String title,
      @Nullable String anchor) {
    this.url = url;
    this.rel = rel;
    this.rev = rev;
    this.type = type;
    this.media = media;
    this.title = title;
    this.anchor = anchor;
  }

  /**
   * Link value.
   * @return url
   */
  @JsonProperty
  @Override
  public URI url() {
    return url;
  }

  /**
   * The relation type of a link is conveyed in the "rel" parameter's value. The "rel" parameter
   * MUST NOT appear more than once in a given link-value; occurrences after the first MUST be
   * ignored by parsers.
   * @return relation type
   */
  @JsonProperty
  @Override
  public Optional<String> rel() {
    return Optional.ofNullable(rel);
  }

  /**
   * The "rev" parameter has been used in the past to indicate that the semantics of the
   * relationship are in the reverse direction. That is, a link from A to B with REL="X" expresses
   * the same relationship as a link from B to A with REV="X". "rev" is deprecated by this
   * specification because it often confuses authors and readers; in most cases, using a separate
   * relation type is preferable.
   * @return relation type
   */
  @JsonProperty
  @Override
  public Optional<String> rev() {
    return Optional.ofNullable(rev);
  }

  /**
   * The "type" parameter, when present, is a hint indicating what the media type of the result of
   * dereferencing the link should be. Note that this is only a hint; for example, it does not
   * override the Content-Type header of a HTTP response obtained by actually following the link.
   * There MUST NOT be more than one type parameter in a link- value.
   * @return type
   */
  @JsonProperty
  @Override
  public Optional<String> type() {
    return Optional.ofNullable(type);
  }

  /**
   * The "media" parameter, when present, is used to indicate intended destination medium or media
   * for style information (see [W3C.REC-html401-19991224], Section 6.13). Note that this may be
   * updated by [W3C.CR-css3-mediaqueries-20090915]). Its value MUST be quoted if it contains a
   * semicolon (";") or comma (","), and there MUST NOT be more than one "media" parameter in a
   * link-value.
   * @return media
   */
  @JsonProperty
  @Override
  public Optional<String> media() {
    return Optional.ofNullable(media);
  }

  /**
   * The "title" parameter, when present, is used to label the destination of a link such that it
   * can be used as a human-readable identifier (e.g., a menu entry) in the language indicated by
   * the Content- Language header (if present). The "title" parameter MUST NOT appear more than once
   * in a given link-value; occurrences after the first MUST be ignored by parsers.
   * @return title
   */
  @JsonProperty
  @Override
  public Optional<String> title() {
    return Optional.ofNullable(title);
  }

  /**
   * When present, the anchor parameter overrides this with another URI, such as a fragment of this
   * resource, or a third resource (i.e., when the anchor value is an absolute URI).
   * @return anchor
   */
  @JsonProperty
  @Override
  public Optional<String> anchor() {
    return Optional.ofNullable(anchor);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Link#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withUrl(URI value) {
    if (this.url == value) return this;
    URI newValue = Objects.requireNonNull(value, "url");
    return new ImmutableLink(newValue, this.rel, this.rev, this.type, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#rel() rel} attribute.
   * @param value The value for rel
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withRel(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "rel");
    if (Objects.equals(this.rel, newValue)) return this;
    return new ImmutableLink(this.url, newValue, this.rev, this.type, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#rel() rel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rel
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withRel(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rel, value)) return this;
    return new ImmutableLink(this.url, value, this.rev, this.type, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#rev() rev} attribute.
   * @param value The value for rev
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withRev(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "rev");
    if (Objects.equals(this.rev, newValue)) return this;
    return new ImmutableLink(this.url, this.rel, newValue, this.type, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#rev() rev} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rev
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withRev(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableLink(this.url, this.rel, value, this.type, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#type() type} attribute.
   * @param value The value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "type");
    if (Objects.equals(this.type, newValue)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, newValue, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#type() type} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, value, this.media, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#media() media} attribute.
   * @param value The value for media
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withMedia(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "media");
    if (Objects.equals(this.media, newValue)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, newValue, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#media() media} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for media
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withMedia(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.media, value)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, value, this.title, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#title() title} attribute.
   * @param value The value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withTitle(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "title");
    if (Objects.equals(this.title, newValue)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, newValue, this.anchor);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#title() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, value, this.anchor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Link#anchor() anchor} attribute.
   * @param value The value for anchor
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withAnchor(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "anchor");
    if (Objects.equals(this.anchor, newValue)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, this.title, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Link#anchor() anchor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for anchor
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withAnchor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.anchor, value)) return this;
    return new ImmutableLink(this.url, this.rel, this.rev, this.type, this.media, this.title, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLink
        && equalTo((ImmutableLink) another);
  }

  private boolean equalTo(ImmutableLink another) {
    return url.equals(another.url)
        && Objects.equals(rel, another.rel)
        && Objects.equals(rev, another.rev)
        && Objects.equals(type, another.type)
        && Objects.equals(media, another.media)
        && Objects.equals(title, another.title)
        && Objects.equals(anchor, another.anchor);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code rel}, {@code rev}, {@code type}, {@code media}, {@code title}, {@code anchor}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + url.hashCode();
    h += (h << 5) + Objects.hashCode(rel);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(media);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(anchor);
    return h;
  }

  /**
   * Prints the immutable value {@code Link} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Link{");
    builder.append("url=").append(url);
    if (rel != null) {
      builder.append(", ");
      builder.append("rel=").append(rel);
    }
    if (rev != null) {
      builder.append(", ");
      builder.append("rev=").append(rev);
    }
    if (type != null) {
      builder.append(", ");
      builder.append("type=").append(type);
    }
    if (media != null) {
      builder.append(", ");
      builder.append("media=").append(media);
    }
    if (title != null) {
      builder.append(", ");
      builder.append("title=").append(title);
    }
    if (anchor != null) {
      builder.append(", ");
      builder.append("anchor=").append(anchor);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Link", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Link {
    @Nullable URI url;
    @Nullable Optional<String> rel = Optional.empty();
    @Nullable Optional<String> rev = Optional.empty();
    @Nullable Optional<String> type = Optional.empty();
    @Nullable Optional<String> media = Optional.empty();
    @Nullable Optional<String> title = Optional.empty();
    @Nullable Optional<String> anchor = Optional.empty();
    @JsonProperty
    public void setUrl(URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setRel(Optional<String> rel) {
      this.rel = rel;
    }
    @JsonProperty
    public void setRev(Optional<String> rev) {
      this.rev = rev;
    }
    @JsonProperty
    public void setType(Optional<String> type) {
      this.type = type;
    }
    @JsonProperty
    public void setMedia(Optional<String> media) {
      this.media = media;
    }
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setAnchor(Optional<String> anchor) {
      this.anchor = anchor;
    }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rev() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> type() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> media() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> anchor() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLink fromJson(Json json) {
    ImmutableLink.Builder builder = ImmutableLink.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.rel != null) {
      builder.rel(json.rel);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.media != null) {
      builder.media(json.media);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.anchor != null) {
      builder.anchor(json.anchor);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Link} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Link instance
   */
  public static ImmutableLink copyOf(Link instance) {
    if (instance instanceof ImmutableLink) {
      return (ImmutableLink) instance;
    }
    return ImmutableLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLink ImmutableLink}.
   * <pre>
   * ImmutableLink.builder()
   *    .url(java.net.URI) // required {@link Link#url() url}
   *    .rel(String) // optional {@link Link#rel() rel}
   *    .rev(String) // optional {@link Link#rev() rev}
   *    .type(String) // optional {@link Link#type() type}
   *    .media(String) // optional {@link Link#media() media}
   *    .title(String) // optional {@link Link#title() title}
   *    .anchor(String) // optional {@link Link#anchor() anchor}
   *    .build();
   * </pre>
   * @return A new ImmutableLink builder
   */
  public static ImmutableLink.Builder builder() {
    return new ImmutableLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLink ImmutableLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Link", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable URI url;
    private @Nullable String rel;
    private @Nullable String rev;
    private @Nullable String type;
    private @Nullable String media;
    private @Nullable String title;
    private @Nullable String anchor;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Link} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Link instance) {
      Objects.requireNonNull(instance, "instance");
      url(instance.url());
      Optional<String> relOptional = instance.rel();
      if (relOptional.isPresent()) {
        rel(relOptional);
      }
      Optional<String> revOptional = instance.rev();
      if (revOptional.isPresent()) {
        rev(revOptional);
      }
      Optional<String> typeOptional = instance.type();
      if (typeOptional.isPresent()) {
        type(typeOptional);
      }
      Optional<String> mediaOptional = instance.media();
      if (mediaOptional.isPresent()) {
        media(mediaOptional);
      }
      Optional<String> titleOptional = instance.title();
      if (titleOptional.isPresent()) {
        title(titleOptional);
      }
      Optional<String> anchorOptional = instance.anchor();
      if (anchorOptional.isPresent()) {
        anchor(anchorOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Link#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(URI url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the optional value {@link Link#rel() rel} to rel.
     * @param rel The value for rel
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rel(String rel) {
      this.rel = Objects.requireNonNull(rel, "rel");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#rel() rel} to rel.
     * @param rel The value for rel
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder rel(Optional<String> rel) {
      this.rel = rel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Link#rev() rev} to rev.
     * @param rev The value for rev
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#rev() rev} to rev.
     * @param rev The value for rev
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder rev(Optional<String> rev) {
      this.rev = rev.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Link#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(Optional<String> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Link#media() media} to media.
     * @param media The value for media
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder media(String media) {
      this.media = Objects.requireNonNull(media, "media");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#media() media} to media.
     * @param media The value for media
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder media(Optional<String> media) {
      this.media = media.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Link#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Link#anchor() anchor} to anchor.
     * @param anchor The value for anchor
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder anchor(String anchor) {
      this.anchor = Objects.requireNonNull(anchor, "anchor");
      return this;
    }

    /**
     * Initializes the optional value {@link Link#anchor() anchor} to anchor.
     * @param anchor The value for anchor
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder anchor(Optional<String> anchor) {
      this.anchor = anchor.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLink ImmutableLink}.
     * @return An immutable instance of Link
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLink(url, rel, rev, type, media, title, anchor);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build Link, some of required attributes are not set " + attributes;
    }
  }
}
