package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.comment.Comment;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitCommentEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitCommentEvent.builder()}.
 */
@Generated(from = "CommitCommentEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitCommentEvent
    implements CommitCommentEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Comment comment;

  private ImmutableCommitCommentEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Comment comment) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.comment = comment;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *The action that was performed. 
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *The repository {@link Comment} created. 
   */
  @JsonProperty
  @Override
  public @Nullable Comment comment() {
    return comment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitCommentEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitCommentEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableCommitCommentEvent(value, this.sender, this.eventInstallation, this.action, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitCommentEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitCommentEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableCommitCommentEvent(this.repository, value, this.eventInstallation, this.action, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitCommentEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitCommentEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableCommitCommentEvent(this.repository, this.sender, value, this.action, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitCommentEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitCommentEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableCommitCommentEvent(this.repository, this.sender, this.eventInstallation, value, this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitCommentEvent#comment() comment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitCommentEvent withComment(@Nullable Comment value) {
    if (this.comment == value) return this;
    return new ImmutableCommitCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitCommentEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitCommentEvent
        && equalTo((ImmutableCommitCommentEvent) another);
  }

  private boolean equalTo(ImmutableCommitCommentEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(comment, another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(comment);
    return h;
  }

  /**
   * Prints the immutable value {@code CommitCommentEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommitCommentEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", comment=" + comment
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitCommentEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommitCommentEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Comment comment;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setComment(@Nullable Comment comment) {
      this.comment = comment;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Comment comment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitCommentEvent fromJson(Json json) {
    ImmutableCommitCommentEvent.Builder builder = ImmutableCommitCommentEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitCommentEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitCommentEvent instance
   */
  public static ImmutableCommitCommentEvent copyOf(CommitCommentEvent instance) {
    if (instance instanceof ImmutableCommitCommentEvent) {
      return (ImmutableCommitCommentEvent) instance;
    }
    return ImmutableCommitCommentEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitCommentEvent ImmutableCommitCommentEvent}.
   * <pre>
   * ImmutableCommitCommentEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link CommitCommentEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link CommitCommentEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link CommitCommentEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link CommitCommentEvent#action() action}
   *    .comment(com.spotify.github.v3.comment.Comment | null) // nullable {@link CommitCommentEvent#comment() comment}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitCommentEvent builder
   */
  public static ImmutableCommitCommentEvent.Builder builder() {
    return new ImmutableCommitCommentEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitCommentEvent ImmutableCommitCommentEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitCommentEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Comment comment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.CommitCommentEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitCommentEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof CommitCommentEvent) {
        CommitCommentEvent instance = (CommitCommentEvent) object;
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        @Nullable Comment commentValue = instance.comment();
        if (commentValue != null) {
          comment(commentValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CommitCommentEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitCommentEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitCommentEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitCommentEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitCommentEvent#comment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comment(@Nullable Comment comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitCommentEvent ImmutableCommitCommentEvent}.
     * @return An immutable instance of CommitCommentEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitCommentEvent build() {
      return new ImmutableCommitCommentEvent(repository, sender, eventInstallation, action, comment);
    }
  }
}
