package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EventInstallation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEventInstallation.builder()}.
 */
@Generated(from = "EventInstallation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEventInstallation
    implements EventInstallation {
  private final Integer id;

  private ImmutableEventInstallation(Integer id) {
    this.id = id;
  }

  /**
   * The Installation ID.
   * @return the ID
   */
  @JsonProperty
  @Override
  public Integer id() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EventInstallation#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEventInstallation withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableEventInstallation(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEventInstallation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEventInstallation
        && equalTo((ImmutableEventInstallation) another);
  }

  private boolean equalTo(ImmutableEventInstallation another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EventInstallation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EventInstallation{"
        + "id=" + id
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "EventInstallation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements EventInstallation {
    @Nullable Integer id;
    @JsonProperty
    public void setId(Integer id) {
      this.id = id;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEventInstallation fromJson(Json json) {
    ImmutableEventInstallation.Builder builder = ImmutableEventInstallation.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link EventInstallation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EventInstallation instance
   */
  public static ImmutableEventInstallation copyOf(EventInstallation instance) {
    if (instance instanceof ImmutableEventInstallation) {
      return (ImmutableEventInstallation) instance;
    }
    return ImmutableEventInstallation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEventInstallation ImmutableEventInstallation}.
   * <pre>
   * ImmutableEventInstallation.builder()
   *    .id(Integer) // required {@link EventInstallation#id() id}
   *    .build();
   * </pre>
   * @return A new ImmutableEventInstallation builder
   */
  public static ImmutableEventInstallation.Builder builder() {
    return new ImmutableEventInstallation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEventInstallation ImmutableEventInstallation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EventInstallation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Integer id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EventInstallation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EventInstallation instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      return this;
    }

    /**
     * Initializes the value for the {@link EventInstallation#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEventInstallation ImmutableEventInstallation}.
     * @return An immutable instance of EventInstallation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEventInstallation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEventInstallation(id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build EventInstallation, some of required attributes are not set " + attributes;
    }
  }
}
