package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.PullRequest;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestEvent.builder()}.
 */
@Generated(from = "PullRequestEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestEvent implements PullRequestEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Integer number;
  private final @Nullable PullRequest pullRequest;

  private ImmutablePullRequestEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Integer number,
      @Nullable PullRequest pullRequest) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.number = number;
    this.pullRequest = pullRequest;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * The action that was performed. Can be one of "assigned", "unassigned", "labeled", "unlabeled",
   * "opened", "edited", "closed", or "reopened", or "synchronize". If the action is "closed" and
   * the merged key is false, the pull request was closed with unmerged commits. If the action is
   * "closed" and the merged key is true, the pull request was merged.
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *The pull request number. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer number() {
    return number;
  }

  /**
   *The pull request 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequest pullRequest() {
    return pullRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutablePullRequestEvent(value, this.sender, this.eventInstallation, this.action, this.number, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutablePullRequestEvent(this.repository, value, this.eventInstallation, this.action, this.number, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutablePullRequestEvent(this.repository, this.sender, value, this.action, this.number, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, value, this.number, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#number() number} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withNumber(@Nullable Integer value) {
    if (Objects.equals(this.number, value)) return this;
    return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestEvent#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequest (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestEvent withPullRequest(@Nullable PullRequest value) {
    if (this.pullRequest == value) return this;
    return new ImmutablePullRequestEvent(this.repository, this.sender, this.eventInstallation, this.action, this.number, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestEvent
        && equalTo((ImmutablePullRequestEvent) another);
  }

  private boolean equalTo(ImmutablePullRequestEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(number, another.number)
        && Objects.equals(pullRequest, another.pullRequest);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code number}, {@code pullRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(number);
    h += (h << 5) + Objects.hashCode(pullRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PullRequestEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", number=" + number
        + ", pullRequest=" + pullRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Integer number;
    @Nullable PullRequest pullRequest;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setNumber(@Nullable Integer number) {
      this.number = number;
    }
    @JsonProperty
    public void setPullRequest(@Nullable PullRequest pullRequest) {
      this.pullRequest = pullRequest;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Integer number() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequest pullRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestEvent fromJson(Json json) {
    ImmutablePullRequestEvent.Builder builder = ImmutablePullRequestEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.number != null) {
      builder.number(json.number);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestEvent instance
   */
  public static ImmutablePullRequestEvent copyOf(PullRequestEvent instance) {
    if (instance instanceof ImmutablePullRequestEvent) {
      return (ImmutablePullRequestEvent) instance;
    }
    return ImmutablePullRequestEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestEvent ImmutablePullRequestEvent}.
   * <pre>
   * ImmutablePullRequestEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link PullRequestEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link PullRequestEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link PullRequestEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link PullRequestEvent#action() action}
   *    .number(Integer | null) // nullable {@link PullRequestEvent#number() number}
   *    .pullRequest(com.spotify.github.v3.prs.PullRequest | null) // nullable {@link PullRequestEvent#pullRequest() pullRequest}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestEvent builder
   */
  public static ImmutablePullRequestEvent.Builder builder() {
    return new ImmutablePullRequestEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestEvent ImmutablePullRequestEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Integer number;
    private @Nullable PullRequest pullRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.PullRequestEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PullRequestEvent) {
        PullRequestEvent instance = (PullRequestEvent) object;
        @Nullable Integer numberValue = instance.number();
        if (numberValue != null) {
          number(numberValue);
        }
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        @Nullable PullRequest pullRequestValue = instance.pullRequest();
        if (pullRequestValue != null) {
          pullRequest(pullRequestValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#number() number} attribute.
     * @param number The value for number (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder number(@Nullable Integer number) {
      this.number = number;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestEvent#pullRequest() pullRequest} attribute.
     * @param pullRequest The value for pullRequest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(@Nullable PullRequest pullRequest) {
      this.pullRequest = pullRequest;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestEvent ImmutablePullRequestEvent}.
     * @return An immutable instance of PullRequestEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestEvent build() {
      return new ImmutablePullRequestEvent(repository, sender, eventInstallation, action, number, pullRequest);
    }
  }
}
