package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.git.Author;
import com.spotify.github.v3.repos.PushCommit;
import com.spotify.github.v3.repos.PushRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PushEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePushEvent.builder()}.
 */
@Generated(from = "PushEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePushEvent implements PushEvent {
  private final @Nullable PushRepository repository;
  private final @Nullable User sender;
  private final @Nullable String ref;
  private final @Nullable String before;
  private final @Nullable String after;
  private final @Nullable Boolean created;
  private final @Nullable Boolean deleted;
  private final @Nullable Boolean forced;
  private final @Nullable String baseRef;
  private final @Nullable String compare;
  private final @Nullable List<PushCommit> commits;
  private final @Nullable Optional<PushCommit> headCommit;
  private final @Nullable Author pusher;

  private ImmutablePushEvent(
      @Nullable PushRepository repository,
      @Nullable User sender,
      @Nullable String ref,
      @Nullable String before,
      @Nullable String after,
      @Nullable Boolean created,
      @Nullable Boolean deleted,
      @Nullable Boolean forced,
      @Nullable String baseRef,
      @Nullable String compare,
      @Nullable List<PushCommit> commits,
      @Nullable Optional<PushCommit> headCommit,
      @Nullable Author pusher) {
    this.repository = repository;
    this.sender = sender;
    this.ref = ref;
    this.before = before;
    this.after = after;
    this.created = created;
    this.deleted = deleted;
    this.forced = forced;
    this.baseRef = baseRef;
    this.compare = compare;
    this.commits = commits;
    this.headCommit = headCommit;
    this.pusher = pusher;
  }

  /**
   *The {@link PushRepository} 
   */
  @JsonProperty
  @Override
  public @Nullable PushRepository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The full Git ref that was pushed. Example: "refs/heads/master". 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *The SHA of the most recent commit on ref before the push. 
   */
  @JsonProperty
  @Override
  public @Nullable String before() {
    return before;
  }

  /**
   *SHA of the repository state after the push. 
   */
  @JsonProperty
  @Override
  public @Nullable String after() {
    return after;
  }

  /**
   *True if given reference was created 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean created() {
    return created;
  }

  /**
   *True if given reference was deleted 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean deleted() {
    return deleted;
  }

  /**
   *True if given reference was force pushed 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean forced() {
    return forced;
  }

  /**
   *Base reference 
   */
  @JsonProperty
  @Override
  public Optional<String> baseRef() {
    return Optional.ofNullable(baseRef);
  }

  /**
   * Compare API URL This is a string because of malformed URIs sent from github. They send
   * unencoded '^' in the uri path.
   */
  @JsonProperty
  @Override
  public @Nullable String compare() {
    return compare;
  }

  /**
   * An array of commit objects describing the pushed commits. (The array includes a maximum of 20
   * commits. If necessary, you can use the Commits API to fetch additional commits. This limit is
   * applied to timeline events only and isn't applied to webhook deliveries.)
   */
  @JsonProperty
  @Override
  public @Nullable List<PushCommit> commits() {
    return commits;
  }

  /**
   *The push commit object of the most recent commit on ref after the push. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<PushCommit> headCommit() {
    return headCommit;
  }

  /**
   *Pusher 
   */
  @JsonProperty
  @Override
  public @Nullable Author pusher() {
    return pusher;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withRepository(@Nullable PushRepository value) {
    if (this.repository == value) return this;
    return new ImmutablePushEvent(
        value,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutablePushEvent(
        this.repository,
        value,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        value,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#before() before} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for before (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withBefore(@Nullable String value) {
    if (Objects.equals(this.before, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        value,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#after() after} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for after (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withAfter(@Nullable String value) {
    if (Objects.equals(this.after, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        value,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#created() created} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withCreated(@Nullable Boolean value) {
    if (Objects.equals(this.created, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        value,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#deleted() deleted} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deleted (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withDeleted(@Nullable Boolean value) {
    if (Objects.equals(this.deleted, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        value,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#forced() forced} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forced (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withForced(@Nullable Boolean value) {
    if (Objects.equals(this.forced, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        value,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PushEvent#baseRef() baseRef} attribute.
   * @param value The value for baseRef
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushEvent withBaseRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "baseRef");
    if (Objects.equals(this.baseRef, newValue)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        newValue,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PushEvent#baseRef() baseRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for baseRef
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushEvent withBaseRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.baseRef, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        value,
        this.compare,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#compare() compare} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compare (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withCompare(@Nullable String value) {
    if (Objects.equals(this.compare, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        value,
        this.commits,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushEvent#commits() commits}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushEvent withCommits(@Nullable PushCommit... elements) {
    if (elements == null) {
      return new ImmutablePushEvent(
          this.repository,
          this.sender,
          this.ref,
          this.before,
          this.after,
          this.created,
          this.deleted,
          this.forced,
          this.baseRef,
          this.compare,
          null,
          this.headCommit,
          this.pusher);
    }
    @Nullable List<PushCommit> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        newValue,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PushEvent#commits() commits}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commits elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePushEvent withCommits(@Nullable Iterable<? extends PushCommit> elements) {
    if (this.commits == elements) return this;
    @Nullable List<PushCommit> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        newValue,
        this.headCommit,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#headCommit() headCommit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headCommit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withHeadCommit(@Nullable Optional<PushCommit> value) {
    if (Objects.equals(this.headCommit, value)) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        value,
        this.pusher);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PushEvent#pusher() pusher} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pusher (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePushEvent withPusher(@Nullable Author value) {
    if (this.pusher == value) return this;
    return new ImmutablePushEvent(
        this.repository,
        this.sender,
        this.ref,
        this.before,
        this.after,
        this.created,
        this.deleted,
        this.forced,
        this.baseRef,
        this.compare,
        this.commits,
        this.headCommit,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePushEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePushEvent
        && equalTo((ImmutablePushEvent) another);
  }

  private boolean equalTo(ImmutablePushEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(ref, another.ref)
        && Objects.equals(before, another.before)
        && Objects.equals(after, another.after)
        && Objects.equals(created, another.created)
        && Objects.equals(deleted, another.deleted)
        && Objects.equals(forced, another.forced)
        && Objects.equals(baseRef, another.baseRef)
        && Objects.equals(compare, another.compare)
        && Objects.equals(commits, another.commits)
        && Objects.equals(headCommit, another.headCommit)
        && Objects.equals(pusher, another.pusher);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code ref}, {@code before}, {@code after}, {@code created}, {@code deleted}, {@code forced}, {@code baseRef}, {@code compare}, {@code commits}, {@code headCommit}, {@code pusher}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(before);
    h += (h << 5) + Objects.hashCode(after);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(deleted);
    h += (h << 5) + Objects.hashCode(forced);
    h += (h << 5) + Objects.hashCode(baseRef);
    h += (h << 5) + Objects.hashCode(compare);
    h += (h << 5) + Objects.hashCode(commits);
    h += (h << 5) + Objects.hashCode(headCommit);
    h += (h << 5) + Objects.hashCode(pusher);
    return h;
  }

  /**
   * Prints the immutable value {@code PushEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PushEvent{");
    if (repository != null) {
      builder.append("repository=").append(repository);
    }
    if (sender != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("sender=").append(sender);
    }
    if (ref != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("ref=").append(ref);
    }
    if (before != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("before=").append(before);
    }
    if (after != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("after=").append(after);
    }
    if (created != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("created=").append(created);
    }
    if (deleted != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("deleted=").append(deleted);
    }
    if (forced != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("forced=").append(forced);
    }
    if (baseRef != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("baseRef=").append(baseRef);
    }
    if (compare != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("compare=").append(compare);
    }
    if (commits != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("commits=").append(commits);
    }
    if (headCommit != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("headCommit=").append(headCommit);
    }
    if (pusher != null) {
      if (builder.length() > 10) builder.append(", ");
      builder.append("pusher=").append(pusher);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PushEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PushEvent {
    @Nullable PushRepository repository;
    @Nullable User sender;
    @Nullable String ref;
    @Nullable String before;
    @Nullable String after;
    @Nullable Boolean created;
    @Nullable Boolean deleted;
    @Nullable Boolean forced;
    @Nullable Optional<String> baseRef = Optional.empty();
    @Nullable String compare;
    @Nullable List<PushCommit> commits = null;
    @Nullable Optional<PushCommit> headCommit;
    @Nullable Author pusher;
    @JsonProperty
    public void setRepository(@Nullable PushRepository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setBefore(@Nullable String before) {
      this.before = before;
    }
    @JsonProperty
    public void setAfter(@Nullable String after) {
      this.after = after;
    }
    @JsonProperty
    public void setCreated(@Nullable Boolean created) {
      this.created = created;
    }
    @JsonProperty
    public void setDeleted(@Nullable Boolean deleted) {
      this.deleted = deleted;
    }
    @JsonProperty
    public void setForced(@Nullable Boolean forced) {
      this.forced = forced;
    }
    @JsonProperty
    public void setBaseRef(Optional<String> baseRef) {
      this.baseRef = baseRef;
    }
    @JsonProperty
    public void setCompare(@Nullable String compare) {
      this.compare = compare;
    }
    @JsonProperty
    public void setCommits(@Nullable List<PushCommit> commits) {
      this.commits = commits;
    }
    @JsonProperty
    public void setHeadCommit(@Nullable Optional<PushCommit> headCommit) {
      this.headCommit = headCommit;
    }
    @JsonProperty
    public void setPusher(@Nullable Author pusher) {
      this.pusher = pusher;
    }
    @Override
    public PushRepository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public String before() { throw new UnsupportedOperationException(); }
    @Override
    public String after() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean created() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean deleted() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean forced() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> baseRef() { throw new UnsupportedOperationException(); }
    @Override
    public String compare() { throw new UnsupportedOperationException(); }
    @Override
    public List<PushCommit> commits() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<PushCommit> headCommit() { throw new UnsupportedOperationException(); }
    @Override
    public Author pusher() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePushEvent fromJson(Json json) {
    ImmutablePushEvent.Builder builder = ImmutablePushEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.before != null) {
      builder.before(json.before);
    }
    if (json.after != null) {
      builder.after(json.after);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.deleted != null) {
      builder.deleted(json.deleted);
    }
    if (json.forced != null) {
      builder.forced(json.forced);
    }
    if (json.baseRef != null) {
      builder.baseRef(json.baseRef);
    }
    if (json.compare != null) {
      builder.compare(json.compare);
    }
    if (json.commits != null) {
      builder.addAllCommits(json.commits);
    }
    if (json.headCommit != null) {
      builder.headCommit(json.headCommit);
    }
    if (json.pusher != null) {
      builder.pusher(json.pusher);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PushEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PushEvent instance
   */
  public static ImmutablePushEvent copyOf(PushEvent instance) {
    if (instance instanceof ImmutablePushEvent) {
      return (ImmutablePushEvent) instance;
    }
    return ImmutablePushEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePushEvent ImmutablePushEvent}.
   * <pre>
   * ImmutablePushEvent.builder()
   *    .repository(com.spotify.github.v3.repos.PushRepository | null) // nullable {@link PushEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link PushEvent#sender() sender}
   *    .ref(String | null) // nullable {@link PushEvent#ref() ref}
   *    .before(String | null) // nullable {@link PushEvent#before() before}
   *    .after(String | null) // nullable {@link PushEvent#after() after}
   *    .created(Boolean | null) // nullable {@link PushEvent#created() created}
   *    .deleted(Boolean | null) // nullable {@link PushEvent#deleted() deleted}
   *    .forced(Boolean | null) // nullable {@link PushEvent#forced() forced}
   *    .baseRef(String) // optional {@link PushEvent#baseRef() baseRef}
   *    .compare(String | null) // nullable {@link PushEvent#compare() compare}
   *    .commits(List&amp;lt;com.spotify.github.v3.repos.PushCommit&amp;gt; | null) // nullable {@link PushEvent#commits() commits}
   *    .headCommit(Optional&amp;lt;com.spotify.github.v3.repos.PushCommit&amp;gt; | null) // nullable {@link PushEvent#headCommit() headCommit}
   *    .pusher(com.spotify.github.v3.git.Author | null) // nullable {@link PushEvent#pusher() pusher}
   *    .build();
   * </pre>
   * @return A new ImmutablePushEvent builder
   */
  public static ImmutablePushEvent.Builder builder() {
    return new ImmutablePushEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePushEvent ImmutablePushEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PushEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable PushRepository repository;
    private @Nullable User sender;
    private @Nullable String ref;
    private @Nullable String before;
    private @Nullable String after;
    private @Nullable Boolean created;
    private @Nullable Boolean deleted;
    private @Nullable Boolean forced;
    private @Nullable String baseRef;
    private @Nullable String compare;
    private List<PushCommit> commits = null;
    private @Nullable Optional<PushCommit> headCommit;
    private @Nullable Author pusher;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PushEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PushEvent instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable PushRepository repositoryValue = instance.repository();
      if (repositoryValue != null) {
        repository(repositoryValue);
      }
      @Nullable User senderValue = instance.sender();
      if (senderValue != null) {
        sender(senderValue);
      }
      @Nullable String refValue = instance.ref();
      if (refValue != null) {
        ref(refValue);
      }
      @Nullable String beforeValue = instance.before();
      if (beforeValue != null) {
        before(beforeValue);
      }
      @Nullable String afterValue = instance.after();
      if (afterValue != null) {
        after(afterValue);
      }
      @Nullable Boolean createdValue = instance.created();
      if (createdValue != null) {
        created(createdValue);
      }
      @Nullable Boolean deletedValue = instance.deleted();
      if (deletedValue != null) {
        deleted(deletedValue);
      }
      @Nullable Boolean forcedValue = instance.forced();
      if (forcedValue != null) {
        forced(forcedValue);
      }
      Optional<String> baseRefOptional = instance.baseRef();
      if (baseRefOptional.isPresent()) {
        baseRef(baseRefOptional);
      }
      @Nullable String compareValue = instance.compare();
      if (compareValue != null) {
        compare(compareValue);
      }
      @Nullable List<PushCommit> commitsValue = instance.commits();
      if (commitsValue != null) {
        addAllCommits(commitsValue);
      }
      @Nullable Optional<PushCommit> headCommitValue = instance.headCommit();
      if (headCommitValue != null) {
        headCommit(headCommitValue);
      }
      @Nullable Author pusherValue = instance.pusher();
      if (pusherValue != null) {
        pusher(pusherValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable PushRepository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#before() before} attribute.
     * @param before The value for before (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder before(@Nullable String before) {
      this.before = before;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#after() after} attribute.
     * @param after The value for after (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder after(@Nullable String after) {
      this.after = after;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#created() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder created(@Nullable Boolean created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#deleted() deleted} attribute.
     * @param deleted The value for deleted (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deleted(@Nullable Boolean deleted) {
      this.deleted = deleted;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#forced() forced} attribute.
     * @param forced The value for forced (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder forced(@Nullable Boolean forced) {
      this.forced = forced;
      return this;
    }

    /**
     * Initializes the optional value {@link PushEvent#baseRef() baseRef} to baseRef.
     * @param baseRef The value for baseRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder baseRef(String baseRef) {
      this.baseRef = Objects.requireNonNull(baseRef, "baseRef");
      return this;
    }

    /**
     * Initializes the optional value {@link PushEvent#baseRef() baseRef} to baseRef.
     * @param baseRef The value for baseRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder baseRef(Optional<String> baseRef) {
      this.baseRef = baseRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#compare() compare} attribute.
     * @param compare The value for compare (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder compare(@Nullable String compare) {
      this.compare = compare;
      return this;
    }

    /**
     * Adds one element to {@link PushEvent#commits() commits} list.
     * @param element A commits element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommits(PushCommit element) {
      if (this.commits == null) {
        this.commits = new ArrayList<PushCommit>();
      }
      this.commits.add(Objects.requireNonNull(element, "commits element"));
      return this;
    }

    /**
     * Adds elements to {@link PushEvent#commits() commits} list.
     * @param elements An array of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommits(PushCommit... elements) {
      if (this.commits == null) {
        this.commits = new ArrayList<PushCommit>();
      }
      for (PushCommit element : elements) {
        this.commits.add(Objects.requireNonNull(element, "commits element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PushEvent#commits() commits} list.
     * @param elements An iterable of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commits(@Nullable Iterable<? extends PushCommit> elements) {
      if (elements == null) {
        this.commits = null;
        return this;
      }
      this.commits = new ArrayList<PushCommit>();
      return addAllCommits(elements);
    }

    /**
     * Adds elements to {@link PushEvent#commits() commits} list.
     * @param elements An iterable of commits elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommits(Iterable<? extends PushCommit> elements) {
      Objects.requireNonNull(elements, "commits element");
      if (this.commits == null) {
        this.commits = new ArrayList<PushCommit>();
      }
      for (PushCommit element : elements) {
        this.commits.add(Objects.requireNonNull(element, "commits element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#headCommit() headCommit} attribute.
     * @param headCommit The value for headCommit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder headCommit(@Nullable Optional<PushCommit> headCommit) {
      this.headCommit = headCommit;
      return this;
    }

    /**
     * Initializes the value for the {@link PushEvent#pusher() pusher} attribute.
     * @param pusher The value for pusher (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pusher(@Nullable Author pusher) {
      this.pusher = pusher;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePushEvent ImmutablePushEvent}.
     * @return An immutable instance of PushEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePushEvent build() {
      return new ImmutablePushEvent(
          repository,
          sender,
          ref,
          before,
          after,
          created,
          deleted,
          forced,
          baseRef,
          compare,
          commits == null ? null : createUnmodifiableList(true, commits),
          headCommit,
          pusher);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
