package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReviewLinks}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReviewLinks.builder()}.
 */
@Generated(from = "ReviewLinks", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReviewLinks implements ReviewLinks {
  private final @Nullable ReviewLinks.Href<URI> html;
  private final @Nullable ReviewLinks.Href<URI> pullRequest;

  private ImmutableReviewLinks(
      @Nullable ReviewLinks.Href<URI> html,
      @Nullable ReviewLinks.Href<URI> pullRequest) {
    this.html = html;
    this.pullRequest = pullRequest;
  }

  /**
   *Html. 
   */
  @JsonProperty
  @Override
  public @Nullable ReviewLinks.Href<URI> html() {
    return html;
  }

  /**
   *Pull Request. 
   */
  @JsonProperty
  @Override
  public @Nullable ReviewLinks.Href<URI> pullRequest() {
    return pullRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewLinks#html() html} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for html (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewLinks withHtml(@Nullable ReviewLinks.Href<URI> value) {
    if (this.html == value) return this;
    return new ImmutableReviewLinks(value, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewLinks#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequest (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReviewLinks withPullRequest(@Nullable ReviewLinks.Href<URI> value) {
    if (this.pullRequest == value) return this;
    return new ImmutableReviewLinks(this.html, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReviewLinks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReviewLinks
        && equalTo((ImmutableReviewLinks) another);
  }

  private boolean equalTo(ImmutableReviewLinks another) {
    return Objects.equals(html, another.html)
        && Objects.equals(pullRequest, another.pullRequest);
  }

  /**
   * Computes a hash code from attributes: {@code html}, {@code pullRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(html);
    h += (h << 5) + Objects.hashCode(pullRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code ReviewLinks} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReviewLinks{"
        + "html=" + html
        + ", pullRequest=" + pullRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReviewLinks", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReviewLinks {
    @Nullable ReviewLinks.Href<URI> html;
    @Nullable ReviewLinks.Href<URI> pullRequest;
    @JsonProperty
    public void setHtml(@Nullable ReviewLinks.Href<URI> html) {
      this.html = html;
    }
    @JsonProperty
    public void setPullRequest(@Nullable ReviewLinks.Href<URI> pullRequest) {
      this.pullRequest = pullRequest;
    }
    @Override
    public ReviewLinks.Href<URI> html() { throw new UnsupportedOperationException(); }
    @Override
    public ReviewLinks.Href<URI> pullRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReviewLinks fromJson(Json json) {
    ImmutableReviewLinks.Builder builder = ImmutableReviewLinks.builder();
    if (json.html != null) {
      builder.html(json.html);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReviewLinks} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReviewLinks instance
   */
  public static ImmutableReviewLinks copyOf(ReviewLinks instance) {
    if (instance instanceof ImmutableReviewLinks) {
      return (ImmutableReviewLinks) instance;
    }
    return ImmutableReviewLinks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReviewLinks ImmutableReviewLinks}.
   * <pre>
   * ImmutableReviewLinks.builder()
   *    .html(com.spotify.github.v3.activity.events.ReviewLinks.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link ReviewLinks#html() html}
   *    .pullRequest(com.spotify.github.v3.activity.events.ReviewLinks.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link ReviewLinks#pullRequest() pullRequest}
   *    .build();
   * </pre>
   * @return A new ImmutableReviewLinks builder
   */
  public static ImmutableReviewLinks.Builder builder() {
    return new ImmutableReviewLinks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReviewLinks ImmutableReviewLinks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReviewLinks", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable ReviewLinks.Href<URI> html;
    private @Nullable ReviewLinks.Href<URI> pullRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReviewLinks} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReviewLinks instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable ReviewLinks.Href<URI> htmlValue = instance.html();
      if (htmlValue != null) {
        html(htmlValue);
      }
      @Nullable ReviewLinks.Href<URI> pullRequestValue = instance.pullRequest();
      if (pullRequestValue != null) {
        pullRequest(pullRequestValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewLinks#html() html} attribute.
     * @param html The value for html (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder html(@Nullable ReviewLinks.Href<URI> html) {
      this.html = html;
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewLinks#pullRequest() pullRequest} attribute.
     * @param pullRequest The value for pullRequest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(@Nullable ReviewLinks.Href<URI> pullRequest) {
      this.pullRequest = pullRequest;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReviewLinks ImmutableReviewLinks}.
     * @return An immutable instance of ReviewLinks
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReviewLinks build() {
      return new ImmutableReviewLinks(html, pullRequest);
    }
  }
}
