package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckSuiteResponseList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckSuiteResponseList.builder()}.
 */
@Generated(from = "CheckSuiteResponseList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckSuiteResponseList
    implements CheckSuiteResponseList {
  private final int totalCount;
  private final List<CheckSuite> checkSuites;

  private ImmutableCheckSuiteResponseList(int totalCount, List<CheckSuite> checkSuites) {
    this.totalCount = totalCount;
    this.checkSuites = checkSuites;
  }

  /**
   * The count.
   * @return the int
   */
  @JsonProperty
  @Override
  public int totalCount() {
    return totalCount;
  }

  /**
   * Check suites list.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<CheckSuite> checkSuites() {
    return checkSuites;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckSuiteResponseList#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckSuiteResponseList withTotalCount(int value) {
    if (this.totalCount == value) return this;
    return new ImmutableCheckSuiteResponseList(value, this.checkSuites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckSuiteResponseList#checkSuites() checkSuites}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckSuiteResponseList withCheckSuites(CheckSuite... elements) {
    List<CheckSuite> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCheckSuiteResponseList(this.totalCount, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckSuiteResponseList#checkSuites() checkSuites}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checkSuites elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckSuiteResponseList withCheckSuites(Iterable<? extends CheckSuite> elements) {
    if (this.checkSuites == elements) return this;
    List<CheckSuite> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCheckSuiteResponseList(this.totalCount, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckSuiteResponseList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckSuiteResponseList
        && equalTo((ImmutableCheckSuiteResponseList) another);
  }

  private boolean equalTo(ImmutableCheckSuiteResponseList another) {
    return totalCount == another.totalCount
        && checkSuites.equals(another.checkSuites);
  }

  /**
   * Computes a hash code from attributes: {@code totalCount}, {@code checkSuites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + totalCount;
    h += (h << 5) + checkSuites.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckSuiteResponseList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckSuiteResponseList{"
        + "totalCount=" + totalCount
        + ", checkSuites=" + checkSuites
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckSuiteResponseList", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckSuiteResponseList {
    int totalCount;
    boolean totalCountIsSet;
    @Nullable List<CheckSuite> checkSuites = Collections.emptyList();
    @JsonProperty
    public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }
    @JsonProperty
    public void setCheckSuites(List<CheckSuite> checkSuites) {
      this.checkSuites = checkSuites;
    }
    @Override
    public int totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public List<CheckSuite> checkSuites() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckSuiteResponseList fromJson(Json json) {
    ImmutableCheckSuiteResponseList.Builder builder = ImmutableCheckSuiteResponseList.builder();
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.checkSuites != null) {
      builder.addAllCheckSuites(json.checkSuites);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckSuiteResponseList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckSuiteResponseList instance
   */
  public static ImmutableCheckSuiteResponseList copyOf(CheckSuiteResponseList instance) {
    if (instance instanceof ImmutableCheckSuiteResponseList) {
      return (ImmutableCheckSuiteResponseList) instance;
    }
    return ImmutableCheckSuiteResponseList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckSuiteResponseList ImmutableCheckSuiteResponseList}.
   * <pre>
   * ImmutableCheckSuiteResponseList.builder()
   *    .totalCount(int) // required {@link CheckSuiteResponseList#totalCount() totalCount}
   *    .addCheckSuites|addAllCheckSuites(com.spotify.github.v3.checks.CheckSuite) // {@link CheckSuiteResponseList#checkSuites() checkSuites} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCheckSuiteResponseList builder
   */
  public static ImmutableCheckSuiteResponseList.Builder builder() {
    return new ImmutableCheckSuiteResponseList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckSuiteResponseList ImmutableCheckSuiteResponseList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckSuiteResponseList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_COUNT = 0x1L;
    private long initBits = 0x1L;

    private int totalCount;
    private List<CheckSuite> checkSuites = new ArrayList<CheckSuite>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckSuiteResponseList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckSuiteResponseList instance) {
      Objects.requireNonNull(instance, "instance");
      totalCount(instance.totalCount());
      addAllCheckSuites(instance.checkSuites());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckSuiteResponseList#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder totalCount(int totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Adds one element to {@link CheckSuiteResponseList#checkSuites() checkSuites} list.
     * @param element A checkSuites element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckSuites(CheckSuite element) {
      this.checkSuites.add(Objects.requireNonNull(element, "checkSuites element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckSuiteResponseList#checkSuites() checkSuites} list.
     * @param elements An array of checkSuites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCheckSuites(CheckSuite... elements) {
      for (CheckSuite element : elements) {
        this.checkSuites.add(Objects.requireNonNull(element, "checkSuites element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckSuiteResponseList#checkSuites() checkSuites} list.
     * @param elements An iterable of checkSuites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder checkSuites(Iterable<? extends CheckSuite> elements) {
      this.checkSuites.clear();
      return addAllCheckSuites(elements);
    }

    /**
     * Adds elements to {@link CheckSuiteResponseList#checkSuites() checkSuites} list.
     * @param elements An iterable of checkSuites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCheckSuites(Iterable<? extends CheckSuite> elements) {
      for (CheckSuite element : elements) {
        this.checkSuites.add(Objects.requireNonNull(element, "checkSuites element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckSuiteResponseList ImmutableCheckSuiteResponseList}.
     * @return An immutable instance of CheckSuiteResponseList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckSuiteResponseList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckSuiteResponseList(totalCount, createUnmodifiableList(true, checkSuites));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      return "Cannot build CheckSuiteResponseList, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
