package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParentItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParentItem.builder()}.
 */
@Generated(from = "ParentItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableParentItem implements ParentItem {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;

  private ImmutableParentItem(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable URI htmlUrl) {
    this.sha = sha;
    this.url = url;
    this.htmlUrl = htmlUrl;
  }

  /**
   * @return The value of the {@code sha} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   * @return The value of the {@code htmlUrl} attribute
   */
  @JsonProperty("html_url")
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParentItem#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParentItem withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableParentItem(value, this.url, this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParentItem#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParentItem withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableParentItem(this.sha, value, this.htmlUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParentItem#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParentItem withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableParentItem(this.sha, this.url, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParentItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParentItem
        && equalTo((ImmutableParentItem) another);
  }

  private boolean equalTo(ImmutableParentItem another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code htmlUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code ParentItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ParentItem{"
        + "sha=" + sha
        + ", url=" + url
        + ", htmlUrl=" + htmlUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ParentItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ParentItem {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty("html_url")
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableParentItem fromJson(Json json) {
    ImmutableParentItem.Builder builder = ImmutableParentItem.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ParentItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParentItem instance
   */
  public static ImmutableParentItem copyOf(ParentItem instance) {
    if (instance instanceof ImmutableParentItem) {
      return (ImmutableParentItem) instance;
    }
    return ImmutableParentItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParentItem ImmutableParentItem}.
   * <pre>
   * ImmutableParentItem.builder()
   *    .sha(String | null) // nullable {@link ParentItem#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link ParentItem#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link ParentItem#htmlUrl() htmlUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableParentItem builder
   */
  public static ImmutableParentItem.Builder builder() {
    return new ImmutableParentItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParentItem ImmutableParentItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParentItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParentItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParentItem instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String shaValue = instance.sha();
      if (shaValue != null) {
        sha(shaValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable URI htmlUrlValue = instance.htmlUrl();
      if (htmlUrlValue != null) {
        htmlUrl(htmlUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ParentItem#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link ParentItem#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link ParentItem#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("html_url")
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableParentItem ImmutableParentItem}.
     * @return An immutable instance of ParentItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParentItem build() {
      return new ImmutableParentItem(sha, url, htmlUrl);
    }
  }
}
