package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Tag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTag.builder()}.
 */
@Generated(from = "Tag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTag implements Tag {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String tag;
  private final @Nullable String message;
  private final @Nullable Author tagger;
  private final @Nullable ReferenceObject object;

  private ImmutableTag(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String tag,
      @Nullable String message,
      @Nullable Author tagger,
      @Nullable ReferenceObject object) {
    this.sha = sha;
    this.url = url;
    this.tag = tag;
    this.message = message;
    this.tagger = tagger;
    this.object = object;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *The tag. 
   */
  @JsonProperty
  @Override
  public @Nullable String tag() {
    return tag;
  }

  /**
   *The tag message. 
   */
  @JsonProperty
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   *An object with information about the individual creating the tag. 
   */
  @JsonProperty
  @Override
  public @Nullable Author tagger() {
    return tagger;
  }

  /**
   *The SHA of the git object this is tagging. 
   */
  @JsonProperty
  @Override
  public @Nullable ReferenceObject object() {
    return object;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableTag(value, this.url, this.tag, this.message, this.tagger, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableTag(this.sha, value, this.tag, this.message, this.tagger, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#tag() tag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tag (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withTag(@Nullable String value) {
    if (Objects.equals(this.tag, value)) return this;
    return new ImmutableTag(this.sha, this.url, value, this.message, this.tagger, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableTag(this.sha, this.url, this.tag, value, this.tagger, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#tagger() tagger} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tagger (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withTagger(@Nullable Author value) {
    if (this.tagger == value) return this;
    return new ImmutableTag(this.sha, this.url, this.tag, this.message, value, this.object);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tag#object() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withObject(@Nullable ReferenceObject value) {
    if (this.object == value) return this;
    return new ImmutableTag(this.sha, this.url, this.tag, this.message, this.tagger, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTag
        && equalTo((ImmutableTag) another);
  }

  private boolean equalTo(ImmutableTag another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(tag, another.tag)
        && Objects.equals(message, another.message)
        && Objects.equals(tagger, another.tagger)
        && Objects.equals(object, another.object);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code tag}, {@code message}, {@code tagger}, {@code object}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(tag);
    h += (h << 5) + Objects.hashCode(message);
    h += (h << 5) + Objects.hashCode(tagger);
    h += (h << 5) + Objects.hashCode(object);
    return h;
  }

  /**
   * Prints the immutable value {@code Tag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tag{"
        + "sha=" + sha
        + ", url=" + url
        + ", tag=" + tag
        + ", message=" + message
        + ", tagger=" + tagger
        + ", object=" + object
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Tag", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Tag {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String tag;
    @Nullable String message;
    @Nullable Author tagger;
    @Nullable ReferenceObject object;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setTag(@Nullable String tag) {
      this.tag = tag;
    }
    @JsonProperty
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @JsonProperty
    public void setTagger(@Nullable Author tagger) {
      this.tagger = tagger;
    }
    @JsonProperty
    public void setObject(@Nullable ReferenceObject object) {
      this.object = object;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String tag() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
    @Override
    public Author tagger() { throw new UnsupportedOperationException(); }
    @Override
    public ReferenceObject object() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTag fromJson(Json json) {
    ImmutableTag.Builder builder = ImmutableTag.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.tag != null) {
      builder.tag(json.tag);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.tagger != null) {
      builder.tagger(json.tagger);
    }
    if (json.object != null) {
      builder.object(json.object);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Tag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tag instance
   */
  public static ImmutableTag copyOf(Tag instance) {
    if (instance instanceof ImmutableTag) {
      return (ImmutableTag) instance;
    }
    return ImmutableTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTag ImmutableTag}.
   * <pre>
   * ImmutableTag.builder()
   *    .sha(String | null) // nullable {@link Tag#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Tag#url() url}
   *    .tag(String | null) // nullable {@link Tag#tag() tag}
   *    .message(String | null) // nullable {@link Tag#message() message}
   *    .tagger(com.spotify.github.v3.git.Author | null) // nullable {@link Tag#tagger() tagger}
   *    .object(com.spotify.github.v3.git.ReferenceObject | null) // nullable {@link Tag#object() object}
   *    .build();
   * </pre>
   * @return A new ImmutableTag builder
   */
  public static ImmutableTag.Builder builder() {
    return new ImmutableTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTag ImmutableTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String tag;
    private @Nullable String message;
    private @Nullable Author tagger;
    private @Nullable ReferenceObject object;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.Tag} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Tag instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Tag) {
        Tag instance = (Tag) object;
        @Nullable Author taggerValue = instance.tagger();
        if (taggerValue != null) {
          tagger(taggerValue);
        }
        @Nullable String tagValue = instance.tag();
        if (tagValue != null) {
          tag(tagValue);
        }
        @Nullable String messageValue = instance.message();
        if (messageValue != null) {
          message(messageValue);
        }
        @Nullable ReferenceObject objectValue = instance.object();
        if (objectValue != null) {
          object(objectValue);
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Tag#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#tag() tag} attribute.
     * @param tag The value for tag (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tag(@Nullable String tag) {
      this.tag = tag;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#tagger() tagger} attribute.
     * @param tagger The value for tagger (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tagger(@Nullable Author tagger) {
      this.tagger = tagger;
      return this;
    }

    /**
     * Initializes the value for the {@link Tag#object() object} attribute.
     * @param object The value for object (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder object(@Nullable ReferenceObject object) {
      this.object = object;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTag ImmutableTag}.
     * @return An immutable instance of Tag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTag build() {
      return new ImmutableTag(sha, url, tag, message, tagger, object);
    }
  }
}
