package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Tree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTree.builder()}.
 */
@Generated(from = "Tree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTree implements Tree {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable List<TreeItem> tree;
  private final @Nullable Boolean truncated;

  private ImmutableTree(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable List<TreeItem> tree,
      @Nullable Boolean truncated) {
    this.sha = sha;
    this.url = url;
    this.tree = tree;
    this.truncated = truncated;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Tree items. 
   */
  @JsonProperty
  @Override
  public @Nullable List<TreeItem> tree() {
    return tree;
  }

  /**
   *If true, the number of items in the tree array exceeded our maximum limit. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean truncated() {
    return truncated;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tree#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTree withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableTree(value, this.url, this.tree, this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tree#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTree withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableTree(this.sha, value, this.tree, this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Tree#tree() tree}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTree withTree(@Nullable TreeItem... elements) {
    if (elements == null) {
      return new ImmutableTree(this.sha, this.url, null, this.truncated);
    }
    @Nullable List<TreeItem> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTree(this.sha, this.url, newValue, this.truncated);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Tree#tree() tree}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tree elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTree withTree(@Nullable Iterable<? extends TreeItem> elements) {
    if (this.tree == elements) return this;
    @Nullable List<TreeItem> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTree(this.sha, this.url, newValue, this.truncated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tree#truncated() truncated} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for truncated (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTree withTruncated(@Nullable Boolean value) {
    if (Objects.equals(this.truncated, value)) return this;
    return new ImmutableTree(this.sha, this.url, this.tree, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTree
        && equalTo((ImmutableTree) another);
  }

  private boolean equalTo(ImmutableTree another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(tree, another.tree)
        && Objects.equals(truncated, another.truncated);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code tree}, {@code truncated}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(tree);
    h += (h << 5) + Objects.hashCode(truncated);
    return h;
  }

  /**
   * Prints the immutable value {@code Tree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Tree{"
        + "sha=" + sha
        + ", url=" + url
        + ", tree=" + tree
        + ", truncated=" + truncated
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Tree", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Tree {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable List<TreeItem> tree = null;
    @Nullable Boolean truncated;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setTree(@Nullable List<TreeItem> tree) {
      this.tree = tree;
    }
    @JsonProperty
    public void setTruncated(@Nullable Boolean truncated) {
      this.truncated = truncated;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public List<TreeItem> tree() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean truncated() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTree fromJson(Json json) {
    ImmutableTree.Builder builder = ImmutableTree.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.tree != null) {
      builder.addAllTree(json.tree);
    }
    if (json.truncated != null) {
      builder.truncated(json.truncated);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Tree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tree instance
   */
  public static ImmutableTree copyOf(Tree instance) {
    if (instance instanceof ImmutableTree) {
      return (ImmutableTree) instance;
    }
    return ImmutableTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTree ImmutableTree}.
   * <pre>
   * ImmutableTree.builder()
   *    .sha(String | null) // nullable {@link Tree#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Tree#url() url}
   *    .tree(List&amp;lt;com.spotify.github.v3.git.TreeItem&amp;gt; | null) // nullable {@link Tree#tree() tree}
   *    .truncated(Boolean | null) // nullable {@link Tree#truncated() truncated}
   *    .build();
   * </pre>
   * @return A new ImmutableTree builder
   */
  public static ImmutableTree.Builder builder() {
    return new ImmutableTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTree ImmutableTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private List<TreeItem> tree = null;
    private @Nullable Boolean truncated;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.Tree} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Tree instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Tree) {
        Tree instance = (Tree) object;
        @Nullable List<TreeItem> treeValue = instance.tree();
        if (treeValue != null) {
          addAllTree(treeValue);
        }
        @Nullable Boolean truncatedValue = instance.truncated();
        if (truncatedValue != null) {
          truncated(truncatedValue);
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Tree#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Tree#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Adds one element to {@link Tree#tree() tree} list.
     * @param element A tree element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTree(TreeItem element) {
      if (this.tree == null) {
        this.tree = new ArrayList<TreeItem>();
      }
      this.tree.add(Objects.requireNonNull(element, "tree element"));
      return this;
    }

    /**
     * Adds elements to {@link Tree#tree() tree} list.
     * @param elements An array of tree elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTree(TreeItem... elements) {
      if (this.tree == null) {
        this.tree = new ArrayList<TreeItem>();
      }
      for (TreeItem element : elements) {
        this.tree.add(Objects.requireNonNull(element, "tree element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Tree#tree() tree} list.
     * @param elements An iterable of tree elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder tree(@Nullable Iterable<? extends TreeItem> elements) {
      if (elements == null) {
        this.tree = null;
        return this;
      }
      this.tree = new ArrayList<TreeItem>();
      return addAllTree(elements);
    }

    /**
     * Adds elements to {@link Tree#tree() tree} list.
     * @param elements An iterable of tree elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTree(Iterable<? extends TreeItem> elements) {
      Objects.requireNonNull(elements, "tree element");
      if (this.tree == null) {
        this.tree = new ArrayList<TreeItem>();
      }
      for (TreeItem element : elements) {
        this.tree.add(Objects.requireNonNull(element, "tree element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Tree#truncated() truncated} attribute.
     * @param truncated The value for truncated (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder truncated(@Nullable Boolean truncated) {
      this.truncated = truncated;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTree ImmutableTree}.
     * @return An immutable instance of Tree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTree build() {
      return new ImmutableTree(sha, url, tree == null ? null : createUnmodifiableList(true, tree), truncated);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
