package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Verification}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVerification.builder()}.
 */
@Generated(from = "Verification", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVerification implements Verification {
  private final @Nullable Boolean verified;
  private final @Nullable String reason;
  private final @Nullable String signature;
  private final @Nullable String payload;

  private ImmutableVerification(
      @Nullable Boolean verified,
      @Nullable String reason,
      @Nullable String signature,
      @Nullable String payload) {
    this.verified = verified;
    this.reason = reason;
    this.signature = signature;
    this.payload = payload;
  }

  /**
   * @return The value of the {@code verified} attribute
   */
  @JsonProperty
  @Override
  public @Nullable Boolean verified() {
    return verified;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code signature} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String signature() {
    return signature;
  }

  /**
   * @return The value of the {@code payload} attribute
   */
  @JsonProperty
  @Override
  public @Nullable String payload() {
    return payload;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verification#verified() verified} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVerification withVerified(@Nullable Boolean value) {
    if (Objects.equals(this.verified, value)) return this;
    return new ImmutableVerification(value, this.reason, this.signature, this.payload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verification#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVerification withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableVerification(this.verified, value, this.signature, this.payload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verification#signature() signature} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signature (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVerification withSignature(@Nullable String value) {
    if (Objects.equals(this.signature, value)) return this;
    return new ImmutableVerification(this.verified, this.reason, value, this.payload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verification#payload() payload} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for payload (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVerification withPayload(@Nullable String value) {
    if (Objects.equals(this.payload, value)) return this;
    return new ImmutableVerification(this.verified, this.reason, this.signature, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVerification} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVerification
        && equalTo((ImmutableVerification) another);
  }

  private boolean equalTo(ImmutableVerification another) {
    return Objects.equals(verified, another.verified)
        && Objects.equals(reason, another.reason)
        && Objects.equals(signature, another.signature)
        && Objects.equals(payload, another.payload);
  }

  /**
   * Computes a hash code from attributes: {@code verified}, {@code reason}, {@code signature}, {@code payload}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(verified);
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(signature);
    h += (h << 5) + Objects.hashCode(payload);
    return h;
  }

  /**
   * Prints the immutable value {@code Verification} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Verification{"
        + "verified=" + verified
        + ", reason=" + reason
        + ", signature=" + signature
        + ", payload=" + payload
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Verification", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Verification {
    @Nullable Boolean verified;
    @Nullable String reason;
    @Nullable String signature;
    @Nullable String payload;
    @JsonProperty
    public void setVerified(@Nullable Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty
    public void setReason(@Nullable String reason) {
      this.reason = reason;
    }
    @JsonProperty
    public void setSignature(@Nullable String signature) {
      this.signature = signature;
    }
    @JsonProperty
    public void setPayload(@Nullable String payload) {
      this.payload = payload;
    }
    @Override
    public Boolean verified() { throw new UnsupportedOperationException(); }
    @Override
    public String reason() { throw new UnsupportedOperationException(); }
    @Override
    public String signature() { throw new UnsupportedOperationException(); }
    @Override
    public String payload() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVerification fromJson(Json json) {
    ImmutableVerification.Builder builder = ImmutableVerification.builder();
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    if (json.signature != null) {
      builder.signature(json.signature);
    }
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Verification} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Verification instance
   */
  public static ImmutableVerification copyOf(Verification instance) {
    if (instance instanceof ImmutableVerification) {
      return (ImmutableVerification) instance;
    }
    return ImmutableVerification.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVerification ImmutableVerification}.
   * <pre>
   * ImmutableVerification.builder()
   *    .verified(Boolean | null) // nullable {@link Verification#verified() verified}
   *    .reason(String | null) // nullable {@link Verification#reason() reason}
   *    .signature(String | null) // nullable {@link Verification#signature() signature}
   *    .payload(String | null) // nullable {@link Verification#payload() payload}
   *    .build();
   * </pre>
   * @return A new ImmutableVerification builder
   */
  public static ImmutableVerification.Builder builder() {
    return new ImmutableVerification.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVerification ImmutableVerification}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Verification", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean verified;
    private @Nullable String reason;
    private @Nullable String signature;
    private @Nullable String payload;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Verification} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Verification instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Boolean verifiedValue = instance.verified();
      if (verifiedValue != null) {
        verified(verifiedValue);
      }
      @Nullable String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      @Nullable String signatureValue = instance.signature();
      if (signatureValue != null) {
        signature(signatureValue);
      }
      @Nullable String payloadValue = instance.payload();
      if (payloadValue != null) {
        payload(payloadValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Verification#verified() verified} attribute.
     * @param verified The value for verified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder verified(@Nullable Boolean verified) {
      this.verified = verified;
      return this;
    }

    /**
     * Initializes the value for the {@link Verification#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link Verification#signature() signature} attribute.
     * @param signature The value for signature (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder signature(@Nullable String signature) {
      this.signature = signature;
      return this;
    }

    /**
     * Initializes the value for the {@link Verification#payload() payload} attribute.
     * @param payload The value for payload (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder payload(@Nullable String payload) {
      this.payload = payload;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVerification ImmutableVerification}.
     * @return An immutable instance of Verification
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVerification build() {
      return new ImmutableVerification(verified, reason, signature, payload);
    }
  }
}
