package com.spotify.github.v3.hooks.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.hooks.WebhookConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebhookCreate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWebhookCreate.builder()}.
 */
@Generated(from = "WebhookCreate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWebhookCreate implements WebhookCreate {
  private final @Nullable String name;
  private final @Nullable Boolean active;
  private final @Nullable List<String> events;
  private final @Nullable WebhookConfig config;

  private ImmutableWebhookCreate(
      @Nullable String name,
      @Nullable Boolean active,
      @Nullable List<String> events,
      @Nullable WebhookConfig config) {
    this.name = name;
    this.active = active;
    this.events = events;
    this.config = config;
  }

  /**
   *Webhook name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Should it be active 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean active() {
    return active;
  }

  /**
   *Events 
   */
  @JsonProperty
  @Override
  public @Nullable List<String> events() {
    return events;
  }

  /**
   *Webhook config. See {@link WebhookConfig} for more details. 
   */
  @JsonProperty
  @Override
  public @Nullable WebhookConfig config() {
    return config;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreate#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhookCreate withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableWebhookCreate(value, this.active, this.events, this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreate#active() active} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for active (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhookCreate withActive(@Nullable Boolean value) {
    if (Objects.equals(this.active, value)) return this;
    return new ImmutableWebhookCreate(this.name, value, this.events, this.config);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookCreate#events() events}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebhookCreate withEvents(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableWebhookCreate(this.name, this.active, null, this.config);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableWebhookCreate(this.name, this.active, newValue, this.config);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookCreate#events() events}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of events elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebhookCreate withEvents(@Nullable Iterable<String> elements) {
    if (this.events == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableWebhookCreate(this.name, this.active, newValue, this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreate#config() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhookCreate withConfig(@Nullable WebhookConfig value) {
    if (this.config == value) return this;
    return new ImmutableWebhookCreate(this.name, this.active, this.events, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebhookCreate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebhookCreate
        && equalTo((ImmutableWebhookCreate) another);
  }

  private boolean equalTo(ImmutableWebhookCreate another) {
    return Objects.equals(name, another.name)
        && Objects.equals(active, another.active)
        && Objects.equals(events, another.events)
        && Objects.equals(config, another.config);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code active}, {@code events}, {@code config}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(events);
    h += (h << 5) + Objects.hashCode(config);
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookCreate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookCreate{"
        + "name=" + name
        + ", active=" + active
        + ", events=" + events
        + ", config=" + config
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "WebhookCreate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements WebhookCreate {
    @Nullable String name;
    @Nullable Boolean active;
    @Nullable List<String> events = null;
    @Nullable WebhookConfig config;
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty
    public void setEvents(@Nullable List<String> events) {
      this.events = events;
    }
    @JsonProperty
    public void setConfig(@Nullable WebhookConfig config) {
      this.config = config;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean active() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> events() { throw new UnsupportedOperationException(); }
    @Override
    public WebhookConfig config() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWebhookCreate fromJson(Json json) {
    ImmutableWebhookCreate.Builder builder = ImmutableWebhookCreate.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.events != null) {
      builder.addAllEvents(json.events);
    }
    if (json.config != null) {
      builder.config(json.config);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link WebhookCreate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookCreate instance
   */
  public static ImmutableWebhookCreate copyOf(WebhookCreate instance) {
    if (instance instanceof ImmutableWebhookCreate) {
      return (ImmutableWebhookCreate) instance;
    }
    return ImmutableWebhookCreate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWebhookCreate ImmutableWebhookCreate}.
   * <pre>
   * ImmutableWebhookCreate.builder()
   *    .name(String | null) // nullable {@link WebhookCreate#name() name}
   *    .active(Boolean | null) // nullable {@link WebhookCreate#active() active}
   *    .events(List&amp;lt;String&amp;gt; | null) // nullable {@link WebhookCreate#events() events}
   *    .config(com.spotify.github.v3.hooks.WebhookConfig | null) // nullable {@link WebhookCreate#config() config}
   *    .build();
   * </pre>
   * @return A new ImmutableWebhookCreate builder
   */
  public static ImmutableWebhookCreate.Builder builder() {
    return new ImmutableWebhookCreate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWebhookCreate ImmutableWebhookCreate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookCreate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String name;
    private @Nullable Boolean active;
    private List<String> events = null;
    private @Nullable WebhookConfig config;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookCreate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WebhookCreate instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable Boolean activeValue = instance.active();
      if (activeValue != null) {
        active(activeValue);
      }
      @Nullable List<String> eventsValue = instance.events();
      if (eventsValue != null) {
        addAllEvents(eventsValue);
      }
      @Nullable WebhookConfig configValue = instance.config();
      if (configValue != null) {
        config(configValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookCreate#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookCreate#active() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link WebhookCreate#events() events} list.
     * @param element A events element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String element) {
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      this.events.add(Objects.requireNonNull(element, "events element"));
      return this;
    }

    /**
     * Adds elements to {@link WebhookCreate#events() events} list.
     * @param elements An array of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String... elements) {
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookCreate#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder events(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.events = null;
        return this;
      }
      this.events = new ArrayList<String>();
      return addAllEvents(elements);
    }

    /**
     * Adds elements to {@link WebhookCreate#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEvents(Iterable<String> elements) {
      Objects.requireNonNull(elements, "events element");
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookCreate#config() config} attribute.
     * @param config The value for config (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder config(@Nullable WebhookConfig config) {
      this.config = config;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebhookCreate ImmutableWebhookCreate}.
     * @return An immutable instance of WebhookCreate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebhookCreate build() {
      return new ImmutableWebhookCreate(name, active, events == null ? null : createUnmodifiableList(true, events), config);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
