package com.spotify.github.v3.prs.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestUpdate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestUpdate.builder()}.
 */
@Generated(from = "PullRequestUpdate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestUpdate implements PullRequestUpdate {
  private final @Nullable String title;
  private final @Nullable String body;
  private final @Nullable String state;

  private ImmutablePullRequestUpdate(
      @Nullable String title,
      @Nullable String body,
      @Nullable String state) {
    this.title = title;
    this.body = body;
    this.state = state;
  }

  /**
   *The title of the pull request. 
   */
  @JsonProperty
  @Override
  public Optional<String> title() {
    return Optional.ofNullable(title);
  }

  /**
   *The contents of the pull request. 
   */
  @JsonProperty
  @Override
  public Optional<String> body() {
    return Optional.ofNullable(body);
  }

  /**
   *State of this Pull Request. Either open or closed. 
   */
  @JsonProperty
  @Override
  public Optional<String> state() {
    return Optional.ofNullable(state);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestUpdate#title() title} attribute.
   * @param value The value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withTitle(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "title");
    if (Objects.equals(this.title, newValue)) return this;
    return new ImmutablePullRequestUpdate(newValue, this.body, this.state);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestUpdate#title() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return new ImmutablePullRequestUpdate(value, this.body, this.state);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestUpdate#body() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withBody(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return new ImmutablePullRequestUpdate(this.title, newValue, this.state);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestUpdate#body() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return new ImmutablePullRequestUpdate(this.title, value, this.state);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestUpdate#state() state} attribute.
   * @param value The value for state
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withState(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "state");
    if (Objects.equals(this.state, newValue)) return this;
    return new ImmutablePullRequestUpdate(this.title, this.body, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestUpdate#state() state} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for state
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestUpdate withState(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.state, value)) return this;
    return new ImmutablePullRequestUpdate(this.title, this.body, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestUpdate
        && equalTo((ImmutablePullRequestUpdate) another);
  }

  private boolean equalTo(ImmutablePullRequestUpdate another) {
    return Objects.equals(title, another.title)
        && Objects.equals(body, another.body)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code body}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestUpdate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequestUpdate{");
    if (title != null) {
      builder.append("title=").append(title);
    }
    if (body != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (state != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("state=").append(state);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestUpdate", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestUpdate {
    @Nullable Optional<String> title = Optional.empty();
    @Nullable Optional<String> body = Optional.empty();
    @Nullable Optional<String> state = Optional.empty();
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setBody(Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setState(Optional<String> state) {
      this.state = state;
    }
    @Override
    public Optional<String> title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> state() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestUpdate fromJson(Json json) {
    ImmutablePullRequestUpdate.Builder builder = ImmutablePullRequestUpdate.builder();
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestUpdate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestUpdate instance
   */
  public static ImmutablePullRequestUpdate copyOf(PullRequestUpdate instance) {
    if (instance instanceof ImmutablePullRequestUpdate) {
      return (ImmutablePullRequestUpdate) instance;
    }
    return ImmutablePullRequestUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestUpdate ImmutablePullRequestUpdate}.
   * <pre>
   * ImmutablePullRequestUpdate.builder()
   *    .title(String) // optional {@link PullRequestUpdate#title() title}
   *    .body(String) // optional {@link PullRequestUpdate#body() body}
   *    .state(String) // optional {@link PullRequestUpdate#state() state}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestUpdate builder
   */
  public static ImmutablePullRequestUpdate.Builder builder() {
    return new ImmutablePullRequestUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestUpdate ImmutablePullRequestUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestUpdate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String title;
    private @Nullable String body;
    private @Nullable String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PullRequestUpdate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestUpdate instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> titleOptional = instance.title();
      if (titleOptional.isPresent()) {
        title(titleOptional);
      }
      Optional<String> bodyOptional = instance.body();
      if (bodyOptional.isPresent()) {
        body(bodyOptional);
      }
      Optional<String> stateOptional = instance.state();
      if (stateOptional.isPresent()) {
        state(stateOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#state() state} to state.
     * @param state The value for state
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder state(String state) {
      this.state = Objects.requireNonNull(state, "state");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestUpdate#state() state} to state.
     * @param state The value for state
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(Optional<String> state) {
      this.state = state.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestUpdate ImmutablePullRequestUpdate}.
     * @return An immutable instance of PullRequestUpdate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestUpdate build() {
      return new ImmutablePullRequestUpdate(title, body, state);
    }
  }
}
