package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.git.Commit;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitItem.builder()}.
 */
@Generated(from = "CommitItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitItem implements CommitItem {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable Commit commit;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI commentsUrl;
  private final @Nullable User author;
  private final @Nullable List<ShaLink> parents;

  private ImmutableCommitItem(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable Commit commit,
      @Nullable URI htmlUrl,
      @Nullable URI commentsUrl,
      @Nullable User author,
      @Nullable List<ShaLink> parents) {
    this.sha = sha;
    this.url = url;
    this.commit = commit;
    this.htmlUrl = htmlUrl;
    this.commentsUrl = commentsUrl;
    this.author = author;
    this.parents = parents;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Commit details 
   */
  @JsonProperty
  @Override
  public @Nullable Commit commit() {
    return commit;
  }

  /**
   *HTML URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Comments URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI commentsUrl() {
    return commentsUrl;
  }

  /**
   *Author user 
   */
  @JsonProperty
  @Override
  public Optional<User> author() {
    return Optional.ofNullable(author);
  }

  /**
   *The SHAs of the commits that were the parents of this commit 
   */
  @JsonProperty
  @Override
  public @Nullable List<ShaLink> parents() {
    return parents;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitItem#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitItem withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableCommitItem(value, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitItem#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitItem withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableCommitItem(this.sha, value, this.commit, this.htmlUrl, this.commentsUrl, this.author, this.parents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitItem#commit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitItem withCommit(@Nullable Commit value) {
    if (this.commit == value) return this;
    return new ImmutableCommitItem(this.sha, this.url, value, this.htmlUrl, this.commentsUrl, this.author, this.parents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitItem#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitItem withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableCommitItem(this.sha, this.url, this.commit, value, this.commentsUrl, this.author, this.parents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitItem#commentsUrl() commentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitItem withCommentsUrl(@Nullable URI value) {
    if (this.commentsUrl == value) return this;
    return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, value, this.author, this.parents);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CommitItem#author() author} attribute.
   * @param value The value for author
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitItem withAuthor(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "author");
    if (this.author == newValue) return this;
    return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, newValue, this.parents);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CommitItem#author() author} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for author
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCommitItem withAuthor(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.author == value) return this;
    return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, value, this.parents);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitItem#parents() parents}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitItem withParents(@Nullable ShaLink... elements) {
    if (elements == null) {
      return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, null);
    }
    @Nullable List<ShaLink> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitItem#parents() parents}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parents elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitItem withParents(@Nullable Iterable<? extends ShaLink> elements) {
    if (this.parents == elements) return this;
    @Nullable List<ShaLink> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCommitItem(this.sha, this.url, this.commit, this.htmlUrl, this.commentsUrl, this.author, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitItem
        && equalTo((ImmutableCommitItem) another);
  }

  private boolean equalTo(ImmutableCommitItem another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(commit, another.commit)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(author, another.author)
        && Objects.equals(parents, another.parents);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code commit}, {@code htmlUrl}, {@code commentsUrl}, {@code author}, {@code parents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(commit);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(author);
    h += (h << 5) + Objects.hashCode(parents);
    return h;
  }

  /**
   * Prints the immutable value {@code CommitItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CommitItem{");
    if (sha != null) {
      builder.append("sha=").append(sha);
    }
    if (url != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (commit != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("commit=").append(commit);
    }
    if (htmlUrl != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (author != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("author=").append(author);
    }
    if (parents != null) {
      if (builder.length() > 11) builder.append(", ");
      builder.append("parents=").append(parents);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommitItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommitItem {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable Commit commit;
    @Nullable URI htmlUrl;
    @Nullable URI commentsUrl;
    @Nullable Optional<User> author = Optional.empty();
    @Nullable List<ShaLink> parents = null;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setCommit(@Nullable Commit commit) {
      this.commit = commit;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty
    public void setAuthor(Optional<User> author) {
      this.author = author;
    }
    @JsonProperty
    public void setParents(@Nullable List<ShaLink> parents) {
      this.parents = parents;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public Commit commit() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> author() { throw new UnsupportedOperationException(); }
    @Override
    public List<ShaLink> parents() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommitItem fromJson(Json json) {
    ImmutableCommitItem.Builder builder = ImmutableCommitItem.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.parents != null) {
      builder.addAllParents(json.parents);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommitItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitItem instance
   */
  public static ImmutableCommitItem copyOf(CommitItem instance) {
    if (instance instanceof ImmutableCommitItem) {
      return (ImmutableCommitItem) instance;
    }
    return ImmutableCommitItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitItem ImmutableCommitItem}.
   * <pre>
   * ImmutableCommitItem.builder()
   *    .sha(String | null) // nullable {@link CommitItem#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link CommitItem#url() url}
   *    .commit(com.spotify.github.v3.git.Commit | null) // nullable {@link CommitItem#commit() commit}
   *    .htmlUrl(java.net.URI | null) // nullable {@link CommitItem#htmlUrl() htmlUrl}
   *    .commentsUrl(java.net.URI | null) // nullable {@link CommitItem#commentsUrl() commentsUrl}
   *    .author(com.spotify.github.v3.User) // optional {@link CommitItem#author() author}
   *    .parents(List&amp;lt;com.spotify.github.v3.git.ShaLink&amp;gt; | null) // nullable {@link CommitItem#parents() parents}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitItem builder
   */
  public static ImmutableCommitItem.Builder builder() {
    return new ImmutableCommitItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitItem ImmutableCommitItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable Commit commit;
    private @Nullable URI htmlUrl;
    private @Nullable URI commentsUrl;
    private @Nullable User author;
    private List<ShaLink> parents = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.CommitItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
      }
      if (object instanceof CommitItem) {
        CommitItem instance = (CommitItem) object;
        @Nullable Commit commitValue = instance.commit();
        if (commitValue != null) {
          commit(commitValue);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI commentsUrlValue = instance.commentsUrl();
        if (commentsUrlValue != null) {
          commentsUrl(commentsUrlValue);
        }
        Optional<User> authorOptional = instance.author();
        if (authorOptional.isPresent()) {
          author(authorOptional);
        }
        @Nullable List<ShaLink> parentsValue = instance.parents();
        if (parentsValue != null) {
          addAllParents(parentsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CommitItem#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitItem#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitItem#commit() commit} attribute.
     * @param commit The value for commit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commit(@Nullable Commit commit) {
      this.commit = commit;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitItem#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitItem#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link CommitItem#author() author} to author.
     * @param author The value for author
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(User author) {
      this.author = Objects.requireNonNull(author, "author");
      return this;
    }

    /**
     * Initializes the optional value {@link CommitItem#author() author} to author.
     * @param author The value for author
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder author(Optional<? extends User> author) {
      this.author = author.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link CommitItem#parents() parents} list.
     * @param element A parents element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParents(ShaLink element) {
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      this.parents.add(Objects.requireNonNull(element, "parents element"));
      return this;
    }

    /**
     * Adds elements to {@link CommitItem#parents() parents} list.
     * @param elements An array of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParents(ShaLink... elements) {
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      for (ShaLink element : elements) {
        this.parents.add(Objects.requireNonNull(element, "parents element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitItem#parents() parents} list.
     * @param elements An iterable of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder parents(@Nullable Iterable<? extends ShaLink> elements) {
      if (elements == null) {
        this.parents = null;
        return this;
      }
      this.parents = new ArrayList<ShaLink>();
      return addAllParents(elements);
    }

    /**
     * Adds elements to {@link CommitItem#parents() parents} list.
     * @param elements An iterable of parents elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParents(Iterable<? extends ShaLink> elements) {
      Objects.requireNonNull(elements, "parents element");
      if (this.parents == null) {
        this.parents = new ArrayList<ShaLink>();
      }
      for (ShaLink element : elements) {
        this.parents.add(Objects.requireNonNull(element, "parents element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitItem ImmutableCommitItem}.
     * @return An immutable instance of CommitItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitItem build() {
      return new ImmutableCommitItem(
          sha,
          url,
          commit,
          htmlUrl,
          commentsUrl,
          author,
          parents == null ? null : createUnmodifiableList(true, parents));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
