package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Content}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContent.builder()}.
 */
@Generated(from = "Content", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContent implements Content {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String type;
  private final @Nullable Integer size;
  private final @Nullable String name;
  private final @Nullable String path;
  private final @Nullable URI gitUrl;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI downloadUrl;
  private final @Nullable String encoding;
  private final @Nullable String content;

  private ImmutableContent(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String type,
      @Nullable Integer size,
      @Nullable String name,
      @Nullable String path,
      @Nullable URI gitUrl,
      @Nullable URI htmlUrl,
      @Nullable URI downloadUrl,
      @Nullable String encoding,
      @Nullable String content) {
    this.sha = sha;
    this.url = url;
    this.type = type;
    this.size = size;
    this.name = name;
    this.path = path;
    this.gitUrl = gitUrl;
    this.htmlUrl = htmlUrl;
    this.downloadUrl = downloadUrl;
    this.encoding = encoding;
    this.content = content;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Content type. E.g file, dir, symlink, submodule 
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   *Content size in bytes 
   */
  @JsonProperty
  @Override
  public @Nullable Integer size() {
    return size;
  }

  /**
   *Content name. E.g. file name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *The content path. 
   */
  @JsonProperty
  @Override
  public @Nullable String path() {
    return path;
  }

  /**
   *Git blob API URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI gitUrl() {
    return gitUrl;
  }

  /**
   *Content URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Content download URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI downloadUrl() {
    return downloadUrl;
  }

  /**
   *Encoding name. E.g. base64 
   */
  @JsonProperty
  @Override
  public @Nullable String encoding() {
    return encoding;
  }

  /**
   *Actual encoded content 
   */
  @JsonProperty
  @Override
  public @Nullable String content() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableContent(
        value,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableContent(
        this.sha,
        value,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        value,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#size() size} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for size (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withSize(@Nullable Integer value) {
    if (Objects.equals(this.size, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        value,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        value,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withPath(@Nullable String value) {
    if (Objects.equals(this.path, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        value,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#gitUrl() gitUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withGitUrl(@Nullable URI value) {
    if (this.gitUrl == value) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        value,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        value,
        this.downloadUrl,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#downloadUrl() downloadUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withDownloadUrl(@Nullable URI value) {
    if (this.downloadUrl == value) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        value,
        this.encoding,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#encoding() encoding} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for encoding (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withEncoding(@Nullable String value) {
    if (Objects.equals(this.encoding, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        value,
        this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Content#content() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContent withContent(@Nullable String value) {
    if (Objects.equals(this.content, value)) return this;
    return new ImmutableContent(
        this.sha,
        this.url,
        this.type,
        this.size,
        this.name,
        this.path,
        this.gitUrl,
        this.htmlUrl,
        this.downloadUrl,
        this.encoding,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContent
        && equalTo((ImmutableContent) another);
  }

  private boolean equalTo(ImmutableContent another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(type, another.type)
        && Objects.equals(size, another.size)
        && Objects.equals(name, another.name)
        && Objects.equals(path, another.path)
        && Objects.equals(gitUrl, another.gitUrl)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(downloadUrl, another.downloadUrl)
        && Objects.equals(encoding, another.encoding)
        && Objects.equals(content, another.content);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code type}, {@code size}, {@code name}, {@code path}, {@code gitUrl}, {@code htmlUrl}, {@code downloadUrl}, {@code encoding}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(gitUrl);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(downloadUrl);
    h += (h << 5) + Objects.hashCode(encoding);
    h += (h << 5) + Objects.hashCode(content);
    return h;
  }

  /**
   * Prints the immutable value {@code Content} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Content{"
        + "sha=" + sha
        + ", url=" + url
        + ", type=" + type
        + ", size=" + size
        + ", name=" + name
        + ", path=" + path
        + ", gitUrl=" + gitUrl
        + ", htmlUrl=" + htmlUrl
        + ", downloadUrl=" + downloadUrl
        + ", encoding=" + encoding
        + ", content=" + content
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Content", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Content {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String type;
    @Nullable Integer size;
    @Nullable String name;
    @Nullable String path;
    @Nullable URI gitUrl;
    @Nullable URI htmlUrl;
    @Nullable URI downloadUrl;
    @Nullable String encoding;
    @Nullable String content;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty
    public void setGitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setDownloadUrl(@Nullable URI downloadUrl) {
      this.downloadUrl = downloadUrl;
    }
    @JsonProperty
    public void setEncoding(@Nullable String encoding) {
      this.encoding = encoding;
    }
    @JsonProperty
    public void setContent(@Nullable String content) {
      this.content = content;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public Integer size() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public URI gitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI downloadUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String encoding() { throw new UnsupportedOperationException(); }
    @Override
    public String content() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContent fromJson(Json json) {
    ImmutableContent.Builder builder = ImmutableContent.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.gitUrl != null) {
      builder.gitUrl(json.gitUrl);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.downloadUrl != null) {
      builder.downloadUrl(json.downloadUrl);
    }
    if (json.encoding != null) {
      builder.encoding(json.encoding);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Content} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Content instance
   */
  public static ImmutableContent copyOf(Content instance) {
    if (instance instanceof ImmutableContent) {
      return (ImmutableContent) instance;
    }
    return ImmutableContent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContent ImmutableContent}.
   * <pre>
   * ImmutableContent.builder()
   *    .sha(String | null) // nullable {@link Content#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link Content#url() url}
   *    .type(String | null) // nullable {@link Content#type() type}
   *    .size(Integer | null) // nullable {@link Content#size() size}
   *    .name(String | null) // nullable {@link Content#name() name}
   *    .path(String | null) // nullable {@link Content#path() path}
   *    .gitUrl(java.net.URI | null) // nullable {@link Content#gitUrl() gitUrl}
   *    .htmlUrl(java.net.URI | null) // nullable {@link Content#htmlUrl() htmlUrl}
   *    .downloadUrl(java.net.URI | null) // nullable {@link Content#downloadUrl() downloadUrl}
   *    .encoding(String | null) // nullable {@link Content#encoding() encoding}
   *    .content(String | null) // nullable {@link Content#content() content}
   *    .build();
   * </pre>
   * @return A new ImmutableContent builder
   */
  public static ImmutableContent.Builder builder() {
    return new ImmutableContent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContent ImmutableContent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Content", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String type;
    private @Nullable Integer size;
    private @Nullable String name;
    private @Nullable String path;
    private @Nullable URI gitUrl;
    private @Nullable URI htmlUrl;
    private @Nullable URI downloadUrl;
    private @Nullable String encoding;
    private @Nullable String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.FolderContent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FolderContent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.repos.Content} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Content instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof FolderContent) {
        FolderContent instance = (FolderContent) object;
        @Nullable String pathValue = instance.path();
        if (pathValue != null) {
          path(pathValue);
        }
        @Nullable Integer sizeValue = instance.size();
        if (sizeValue != null) {
          size(sizeValue);
        }
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI downloadUrlValue = instance.downloadUrl();
        if (downloadUrlValue != null) {
          downloadUrl(downloadUrlValue);
        }
        @Nullable String typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
        @Nullable URI gitUrlValue = instance.gitUrl();
        if (gitUrlValue != null) {
          gitUrl(gitUrlValue);
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
      }
      if (object instanceof Content) {
        Content instance = (Content) object;
        @Nullable String encodingValue = instance.encoding();
        if (encodingValue != null) {
          encoding(encodingValue);
        }
        @Nullable String contentValue = instance.content();
        if (contentValue != null) {
          content(contentValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Content#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#size() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#path() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#gitUrl() gitUrl} attribute.
     * @param gitUrl The value for gitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder gitUrl(@Nullable URI gitUrl) {
      this.gitUrl = gitUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#downloadUrl() downloadUrl} attribute.
     * @param downloadUrl The value for downloadUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder downloadUrl(@Nullable URI downloadUrl) {
      this.downloadUrl = downloadUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#encoding() encoding} attribute.
     * @param encoding The value for encoding (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder encoding(@Nullable String encoding) {
      this.encoding = encoding;
      return this;
    }

    /**
     * Initializes the value for the {@link Content#content() content} attribute.
     * @param content The value for content (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder content(@Nullable String content) {
      this.content = content;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContent ImmutableContent}.
     * @return An immutable instance of Content
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContent build() {
      return new ImmutableContent(sha, url, type, size, name, path, gitUrl, htmlUrl, downloadUrl, encoding, content);
    }
  }
}
