package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Organization}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOrganization.builder()}.
 */
@Generated(from = "Organization", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOrganization implements Organization {
  private final @Nullable String login;
  private final @Nullable Long id;
  private final @Nullable URI url;
  private final @Nullable URI reposUrl;
  private final @Nullable URI eventsUrl;
  private final @Nullable String membersUrl;
  private final @Nullable String publicMembersUrl;
  private final @Nullable URI avatarUrl;

  private ImmutableOrganization(
      @Nullable String login,
      @Nullable Long id,
      @Nullable URI url,
      @Nullable URI reposUrl,
      @Nullable URI eventsUrl,
      @Nullable String membersUrl,
      @Nullable String publicMembersUrl,
      @Nullable URI avatarUrl) {
    this.login = login;
    this.id = id;
    this.url = url;
    this.reposUrl = reposUrl;
    this.eventsUrl = eventsUrl;
    this.membersUrl = membersUrl;
    this.publicMembersUrl = publicMembersUrl;
    this.avatarUrl = avatarUrl;
  }

  /**
   *The organization's username. 
   */
  @JsonProperty
  @Override
  public @Nullable String login() {
    return login;
  }

  /**
   *Organization id. 
   */
  @JsonProperty
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   *API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Repositories API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI reposUrl() {
    return reposUrl;
  }

  /**
   *Events API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI eventsUrl() {
    return eventsUrl;
  }

  /**
   *Members API URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String membersUrl() {
    return membersUrl;
  }

  /**
   *Public members API URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String publicMembersUrl() {
    return publicMembersUrl;
  }

  /**
   *Avatar URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI avatarUrl() {
    return avatarUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#login() login} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for login (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withLogin(@Nullable String value) {
    if (Objects.equals(this.login, value)) return this;
    return new ImmutableOrganization(
        value,
        this.id,
        this.url,
        this.reposUrl,
        this.eventsUrl,
        this.membersUrl,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableOrganization(
        this.login,
        value,
        this.url,
        this.reposUrl,
        this.eventsUrl,
        this.membersUrl,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        value,
        this.reposUrl,
        this.eventsUrl,
        this.membersUrl,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#reposUrl() reposUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reposUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withReposUrl(@Nullable URI value) {
    if (this.reposUrl == value) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        this.url,
        value,
        this.eventsUrl,
        this.membersUrl,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#eventsUrl() eventsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withEventsUrl(@Nullable URI value) {
    if (this.eventsUrl == value) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        this.url,
        this.reposUrl,
        value,
        this.membersUrl,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#membersUrl() membersUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for membersUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withMembersUrl(@Nullable String value) {
    if (Objects.equals(this.membersUrl, value)) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        this.url,
        this.reposUrl,
        this.eventsUrl,
        value,
        this.publicMembersUrl,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#publicMembersUrl() publicMembersUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for publicMembersUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withPublicMembersUrl(@Nullable String value) {
    if (Objects.equals(this.publicMembersUrl, value)) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        this.url,
        this.reposUrl,
        this.eventsUrl,
        this.membersUrl,
        value,
        this.avatarUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Organization#avatarUrl() avatarUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for avatarUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrganization withAvatarUrl(@Nullable URI value) {
    if (this.avatarUrl == value) return this;
    return new ImmutableOrganization(
        this.login,
        this.id,
        this.url,
        this.reposUrl,
        this.eventsUrl,
        this.membersUrl,
        this.publicMembersUrl,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOrganization} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOrganization
        && equalTo((ImmutableOrganization) another);
  }

  private boolean equalTo(ImmutableOrganization another) {
    return Objects.equals(login, another.login)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(reposUrl, another.reposUrl)
        && Objects.equals(eventsUrl, another.eventsUrl)
        && Objects.equals(membersUrl, another.membersUrl)
        && Objects.equals(publicMembersUrl, another.publicMembersUrl)
        && Objects.equals(avatarUrl, another.avatarUrl);
  }

  /**
   * Computes a hash code from attributes: {@code login}, {@code id}, {@code url}, {@code reposUrl}, {@code eventsUrl}, {@code membersUrl}, {@code publicMembersUrl}, {@code avatarUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(login);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(reposUrl);
    h += (h << 5) + Objects.hashCode(eventsUrl);
    h += (h << 5) + Objects.hashCode(membersUrl);
    h += (h << 5) + Objects.hashCode(publicMembersUrl);
    h += (h << 5) + Objects.hashCode(avatarUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code Organization} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Organization{"
        + "login=" + login
        + ", id=" + id
        + ", url=" + url
        + ", reposUrl=" + reposUrl
        + ", eventsUrl=" + eventsUrl
        + ", membersUrl=" + membersUrl
        + ", publicMembersUrl=" + publicMembersUrl
        + ", avatarUrl=" + avatarUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Organization", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Organization {
    @Nullable String login;
    @Nullable Long id;
    @Nullable URI url;
    @Nullable URI reposUrl;
    @Nullable URI eventsUrl;
    @Nullable String membersUrl;
    @Nullable String publicMembersUrl;
    @Nullable URI avatarUrl;
    @JsonProperty
    public void setLogin(@Nullable String login) {
      this.login = login;
    }
    @JsonProperty
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setReposUrl(@Nullable URI reposUrl) {
      this.reposUrl = reposUrl;
    }
    @JsonProperty
    public void setEventsUrl(@Nullable URI eventsUrl) {
      this.eventsUrl = eventsUrl;
    }
    @JsonProperty
    public void setMembersUrl(@Nullable String membersUrl) {
      this.membersUrl = membersUrl;
    }
    @JsonProperty
    public void setPublicMembersUrl(@Nullable String publicMembersUrl) {
      this.publicMembersUrl = publicMembersUrl;
    }
    @JsonProperty
    public void setAvatarUrl(@Nullable URI avatarUrl) {
      this.avatarUrl = avatarUrl;
    }
    @Override
    public String login() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI reposUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI eventsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String membersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String publicMembersUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI avatarUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOrganization fromJson(Json json) {
    ImmutableOrganization.Builder builder = ImmutableOrganization.builder();
    if (json.login != null) {
      builder.login(json.login);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.reposUrl != null) {
      builder.reposUrl(json.reposUrl);
    }
    if (json.eventsUrl != null) {
      builder.eventsUrl(json.eventsUrl);
    }
    if (json.membersUrl != null) {
      builder.membersUrl(json.membersUrl);
    }
    if (json.publicMembersUrl != null) {
      builder.publicMembersUrl(json.publicMembersUrl);
    }
    if (json.avatarUrl != null) {
      builder.avatarUrl(json.avatarUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Organization} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Organization instance
   */
  public static ImmutableOrganization copyOf(Organization instance) {
    if (instance instanceof ImmutableOrganization) {
      return (ImmutableOrganization) instance;
    }
    return ImmutableOrganization.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOrganization ImmutableOrganization}.
   * <pre>
   * ImmutableOrganization.builder()
   *    .login(String | null) // nullable {@link Organization#login() login}
   *    .id(Long | null) // nullable {@link Organization#id() id}
   *    .url(java.net.URI | null) // nullable {@link Organization#url() url}
   *    .reposUrl(java.net.URI | null) // nullable {@link Organization#reposUrl() reposUrl}
   *    .eventsUrl(java.net.URI | null) // nullable {@link Organization#eventsUrl() eventsUrl}
   *    .membersUrl(String | null) // nullable {@link Organization#membersUrl() membersUrl}
   *    .publicMembersUrl(String | null) // nullable {@link Organization#publicMembersUrl() publicMembersUrl}
   *    .avatarUrl(java.net.URI | null) // nullable {@link Organization#avatarUrl() avatarUrl}
   *    .build();
   * </pre>
   * @return A new ImmutableOrganization builder
   */
  public static ImmutableOrganization.Builder builder() {
    return new ImmutableOrganization.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOrganization ImmutableOrganization}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Organization", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String login;
    private @Nullable Long id;
    private @Nullable URI url;
    private @Nullable URI reposUrl;
    private @Nullable URI eventsUrl;
    private @Nullable String membersUrl;
    private @Nullable String publicMembersUrl;
    private @Nullable URI avatarUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Organization} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Organization instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String loginValue = instance.login();
      if (loginValue != null) {
        login(loginValue);
      }
      @Nullable Long idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable URI reposUrlValue = instance.reposUrl();
      if (reposUrlValue != null) {
        reposUrl(reposUrlValue);
      }
      @Nullable URI eventsUrlValue = instance.eventsUrl();
      if (eventsUrlValue != null) {
        eventsUrl(eventsUrlValue);
      }
      @Nullable String membersUrlValue = instance.membersUrl();
      if (membersUrlValue != null) {
        membersUrl(membersUrlValue);
      }
      @Nullable String publicMembersUrlValue = instance.publicMembersUrl();
      if (publicMembersUrlValue != null) {
        publicMembersUrl(publicMembersUrlValue);
      }
      @Nullable URI avatarUrlValue = instance.avatarUrl();
      if (avatarUrlValue != null) {
        avatarUrl(avatarUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#login() login} attribute.
     * @param login The value for login (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder login(@Nullable String login) {
      this.login = login;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#reposUrl() reposUrl} attribute.
     * @param reposUrl The value for reposUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reposUrl(@Nullable URI reposUrl) {
      this.reposUrl = reposUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#eventsUrl() eventsUrl} attribute.
     * @param eventsUrl The value for eventsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder eventsUrl(@Nullable URI eventsUrl) {
      this.eventsUrl = eventsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#membersUrl() membersUrl} attribute.
     * @param membersUrl The value for membersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder membersUrl(@Nullable String membersUrl) {
      this.membersUrl = membersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#publicMembersUrl() publicMembersUrl} attribute.
     * @param publicMembersUrl The value for publicMembersUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder publicMembersUrl(@Nullable String publicMembersUrl) {
      this.publicMembersUrl = publicMembersUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Organization#avatarUrl() avatarUrl} attribute.
     * @param avatarUrl The value for avatarUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder avatarUrl(@Nullable URI avatarUrl) {
      this.avatarUrl = avatarUrl;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOrganization ImmutableOrganization}.
     * @return An immutable instance of Organization
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOrganization build() {
      return new ImmutableOrganization(login, id, url, reposUrl, eventsUrl, membersUrl, publicMembersUrl, avatarUrl);
    }
  }
}
